% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{cpp_map}
\alias{cpp_map}
\title{Create map}
\usage{
cpp_map(keys, values)
}
\arguments{
\item{keys}{An integer, numeric, character, or logical vector.}

\item{values}{An integer, numeric, character, or logical vector.}
}
\value{
Returns a CppMap object referencing a map in C++.
}
\description{
Create a map. Maps are key-value pairs sorted by unique keys.
}
\details{
Maps are associative containers. They do not provide random access through an index. I.e. \code{m[2]} does not return the second element.

C++ map methods implemented in this package are \link{at}, \link{clear}, \link{contains}, \link{count}, \link{emplace}, \link{empty}, \link{erase}, 
\link{insert}, \link{insert_or_assign}, \link{max_size}, \link{merge}, \link{size}, and \link{try_emplace}. The package also adds the \link{==} and 
\link{[} operators and various helper functions (\link{print}, \link{to_r}, \link{type}).

All object-creating methods in this package begin with \code{cpp_} to avoid clashes with functions from other packages, such as \code{utils::stack} and 
\code{base::vector}.
}
\examples{
m <- cpp_map(4:6, seq.int(1, by = 0.5, length.out = 3L))
m
# [4,1] [5,1.5] [6,2]

insert(m, seq.int(100, by = 0.1, length.out = 3L), 14:16)
m
# [4,1] [5,1.5] [6,2] [14,100] [15,100.1] [16,100.2]

print(m, from = 6)
# [6,2] [14,100] [15,100.1] [16,100.2]

m <- cpp_map(c("world", "hello", "there"), 4:6)
m
# ["hello",5] ["there",6] ["world",4]

erase(m, "there")
m
# ["hello",5] ["world",4] 

}
\seealso{
\link{cpp_unordered_map}, \link{cpp_multimap}, \link{cpp_unordered_multimap}.
}
