% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitAndTestCompRiskReg.R
\name{fitReg}
\alias{fitReg}
\title{Regression Models for Competing Risks}
\usage{
fitReg(time, risk, group, cens = NULL)
}
\arguments{
\item{time}{vector with times of the first event or follow-up, must be numeric.}

\item{risk}{vector with type of event, can be numeric or factor/character.}

\item{group}{vector with group variable, can be numeric or factor/character.}

\item{cens}{value of 'risk' indicating censored observation (if NULL, the first value of 'risk' vector will be taken).}
}
\value{
a list of length n, where n is number of different types of events. Each element of a list is a result of crr function from cmprsk package for given type of event.
}
\description{
fits Cox model for every type of an event including occuring of competing risks.
}
\examples{
fitReg(time = LUAD$time, risk = LUAD$event, group = LUAD$gender, cens = "alive")
}
\seealso{
\code{\link[cmprsk]{crr}}
}
