% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{marg_pow}
\alias{marg_pow}
\title{Marginal log-likelihood and posterior density of discrete power law via numerical integration}
\usage{
marg_pow(df, lower, upper, m_alpha, s_alpha, by = 0.001)
}
\arguments{
\item{df}{A data frame with at least two columns, x & count}

\item{lower}{Real number greater than 1, lower limit for numerical integration}

\item{upper}{Real number greater than lower, upper limit for numerical integration}

\item{m_alpha}{Real number, mean of the prior normal distribution for alpha}

\item{s_alpha}{Positive real number, standard deviation of the prior normal distribution for alpha}

\item{by}{Positive real number, the width of subintervals between lower and upper, for numerical integration and posterior density evaluation}
}
\value{
A list: \code{log.marginal} is the marginal log-likelihood, \code{posterior} is a data frame of non-zero posterior densities
}
\description{
Marginal log-likelihood and posterior density of discrete power law via numerical integration
}
