% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{mcmc_mix1_wrapper}
\alias{mcmc_mix1_wrapper}
\title{Wrapper of mcmc_mix1}
\usage{
mcmc_mix1_wrapper(
  df,
  seed,
  u_max = 2000L,
  log_diff_max = 11,
  a_psiu = 0.1,
  b_psiu = 0.9,
  m_alpha1 = 0,
  s_alpha1 = 10,
  a_theta1 = 1,
  b_theta1 = 1,
  m_alpha2 = 0,
  s_alpha2 = 10,
  positive = FALSE,
  iter = 20000L,
  thin = 1L,
  burn = 10000L,
  freq = 100L,
  invts = 1,
  mc3_or_marg = TRUE,
  x_max = 1e+05
)
}
\arguments{
\item{df}{A data frame with at least two columns, x & count}

\item{seed}{Integer for \code{set.seed}}

\item{u_max}{Scalar (default 2000), positive integer for the maximum threshold to be passed to \code{obtain_u_set_mix1}}

\item{log_diff_max}{Positive real number, the value such that thresholds with profile posterior density not less than the maximum posterior density - \code{log_diff_max} will be kept}

\item{a_psiu, b_psiu, m_alpha1, s_alpha1, a_theta1, b_theta1, m_alpha2, s_alpha2}{Scalars, real numbers representing the hyperparameters of the prior distributions for the respective parameters. See details for the specification of the priors.}

\item{positive}{Boolean, is alpha1 positive (TRUE) or unbounded (FALSE)?}

\item{iter}{Positive integer representing the length of the MCMC output}

\item{thin}{Positive integer representing the thinning in the MCMC}

\item{burn}{Non-negative integer representing the burn-in of the MCMC}

\item{freq}{Positive integer representing the frequency of the sampled values being printed}

\item{invts}{Vector of the inverse temperatures for Metropolis-coupled MCMC (if mc3_or_marg = TRUE) or power posterior (if mc3_or_marg = FALSE)}

\item{mc3_or_marg}{Boolean, is Metropolis-coupled MCMC to be used? Ignored if invts = c(1.0)}

\item{x_max}{Scalar (default 100000), positive integer limit for computing the normalising constant}
}
\value{
A list returned by \code{mcmc_mix1}
}
\description{
Wrapper of mcmc_mix1
}
