% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_roche.R
\name{roche_pvalue}
\alias{roche_pvalue}
\alias{label_roche_pvalue}
\title{Round p-values}
\usage{
roche_pvalue(
  x,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

label_roche_pvalue(
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)
}
\arguments{
\item{x}{(\code{numeric})\cr
Numeric vector of p-values.}

\item{big.mark}{(\code{string})\cr
Character used between every 3 digits to separate
hundreds/thousands/millions/etc.
Default is \code{","}, except when \code{decimal.mark = ","} when the default is a space.}

\item{decimal.mark}{(\code{string})\cr
The character to be used to indicate the numeric decimal point.
Default is \code{"."}  or \code{getOption("OutDec")}}

\item{...}{Arguments passed on to \code{base::format()}}
}
\value{
A character vector of rounded p-values
}
\description{
Round p-values
}
\examples{
x <- c(0.0000001, 0.123456)

roche_pvalue(x)
label_roche_pvalue()(x)
}
