% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sims.R
\name{twoarm_sim}
\alias{twoarm_sim}
\title{Simulates data from a two-arm parallel cluster randomised trial}
\usage{
twoarm_sim(
  nJ = c(7, 7),
  N = 20,
  mu = rep(1, 2),
  beta = c(0, 0),
  sig_cl = rep(0.05, 2)
)
}
\arguments{
\item{nJ}{Vector of two integers with the number of clusters in treatment and
control arms}

\item{N}{Number of individuals per cluster}

\item{mu}{Vector of two numeric values with the intercept terms for the two models on the log
scale}

\item{beta}{Vector of two numeric values that are the treatment effect parameters in the two models}

\item{sig_cl}{Vector of two values equal to the variance of the random effect in each model}
}
\value{
A list consisting of: (1) data frame with the cluster IDs (cl), treatment effect indicators (treat),
and two outcomes (y1, y2), and (2) the values of the treatment effect parameters used in the simulation.
}
\description{
Simple simulation of two Poisson distributed outcomes for a two-arm
parallel cluster randomised trial with no baseline measures. A log-linear model
is specified y~Poisson(lambda) with lambda = exp(mu + beta*D + theta) where D is the
treatment effect indicator equal to one in clusters with the treatment and zero
otherwise, and theta~N(0,sigma^2) is the cluster random effect. Used for testing
error rates of the methods.
}
\examples{
out <- twoarm_sim()
data <- out[[1]]
}
