% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_table}
\alias{plot_table}
\title{plot_table}
\usage{
plot_table(
  grid_table,
  theme = c("cyan", "grey", "green", "red", "blue", "purple"),
  title = NULL,
  title.size = 12,
  title.color = "black",
  title.face = "bold",
  title.position = "middle",
  subtitle = NULL,
  subtitle.size = 8,
  subtitle.color = "black",
  subtitle.face = "plain",
  subtitle.position = "middle",
  tile.color = "white",
  tile.size = 1,
  colname.size = 3,
  colname.color = "white",
  colname.face = "bold",
  colname.fill.color = love_color("dark_cyan"),
  text.size = 3,
  text.color = love_color("dark_grey"),
  text.face = "plain",
  text.fill.color = c("white", love_color("pale_grey"))
)
}
\arguments{
\item{grid_table}{A data.frame or table}

\item{theme}{The theme of color, "cyan","grey","green","red","blue","purple" are available.}

\item{title}{The title of table}

\item{title.size}{The title size of plot.}

\item{title.color}{The title color.}

\item{title.face}{The title face, such as "plain", "bold".}

\item{title.position}{The title position,such as "left","middle","right".}

\item{subtitle}{The subtitle of table}

\item{subtitle.size}{The subtitle size.}

\item{subtitle.color}{The subtitle color.}

\item{subtitle.face}{The subtitle face, such as "plain", "bold",default is "bold".}

\item{subtitle.position}{The subtitle position,such as "left","middle","right", default is "middle".}

\item{tile.color}{The color of table lines, default is 'white'.}

\item{tile.size}{The size of table lines , default is 1.}

\item{colname.size}{The size of colnames, default is 3.}

\item{colname.color}{The color of colnames, default is 'white'.}

\item{colname.face}{The face of colnames,default is 'bold'.}

\item{colname.fill.color}{The fill color of colnames, default is love_color("dark_cyan").}

\item{text.size}{The size of text, default is 3.}

\item{text.color}{The color of text, default is love_color("dark_grey").}

\item{text.face}{The face of text, default is 'plain'.}

\item{text.fill.color}{The fill color of text, default is c('white',love_color("pale_grey").}
}
\description{
\code{plot_table} is for table visualizaiton.
}
\examples{
iv_list = get_psi_iv_all(dat = UCICreditCard[1:1000, ],
                         x_list = names(UCICreditCard)[3:5], equal_bins = TRUE,
                         target = "default.payment.next.month", ex_cols = "ID|apply_date")
iv_dt =get_psi_iv(UCICreditCard, x = "PAY_3",
                  target = "default.payment.next.month", bins_total = TRUE)

plot_table(iv_dt)
}
