% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_anaylsis.R
\name{rules_result}
\alias{rules_result}
\title{rules_result}
\usage{
rules_result(dat, rules_list, yes = "reject", no = "pass")
}
\arguments{
\item{dat}{A data.frame}

\item{rules_list}{A list of rules.}

\item{yes}{Default is 'reject'.}

\item{no}{Default is 'pass'.}
}
\value{
A vector with 'pass' and 'reject'.
}
\description{
\code{rules_result} This function is used to get rules results.
}
\examples{
train_test = train_test_split(UCICreditCard, split_type = "Random", prop = 0.8, save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
dat_train$default.payment.next.month = as.numeric(dat_train$default.payment.next.month)
rules_list = get_ctree_rules(tree_fit = NULL, train_dat = dat_train[, 8:26],
                             target ="default.payment.next.month", test_dat = dat_test)[1:3,2]
dat_test$rules_result = rules_result(rules_list = rules_list[3], dat = dat_test)

}
\seealso{
\code{\link{get_ctree_rules}},
\code{\link{check_rules}},
\code{\link{rules_filter}}
}
