% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_rates.R
\name{get_rates}
\alias{get_rates}
\title{Get interest rates from rates.RData or the Markit website}
\usage{
get_rates(date, currency)
}
\arguments{
\item{date}{Trade date. The rates for a trade date T are published on T-1
weekday. This date refers to the day on which we want the CDS to be priced,
not the date for the interest rates as the interest rates will be used is
the day before the trade date. Eg. If we are trying to find the rates used
to price a CDS on 2014-04-22, it will return the rates of 2014-04-21}

\item{currency}{the three-letter currency code. As of now, it works for USD,
  EUR, and JPY. The default is USD.}
}
\value{
a data frame that contains date (the CDS pricing date),
}
\description{
\code{get_rates} returns the deposits and swap rates for the day input, along
with the date conventions for that specific currency. The day input should be
a weekday. If not, go to the most recent previous weekday.
}
\examples{
\dontrun{
get_rates(as.Date("2014-05-07"), currency = "USD")
}
}

