% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crest.set_modern_data.R
\name{crest.set_modern_data}
\alias{crest.set_modern_data}
\title{Format a \code{crestObj} with private data.}
\usage{
crest.set_modern_data(
  distributions,
  climate,
  df = NA,
  climate_space = NA,
  weight = FALSE,
  minGridCells = 0,
  selectedTaxa = NA,
  site_info = c(NA, NA),
  site_name = NA,
  site_climate = rep(NA, length(climate)),
  verbose = TRUE
)
}
\arguments{
\item{distributions}{A dataframe containing the presence records of the
studied proxies and their associated climate values.}

\item{climate}{A vector of the climate variables to extract. See
\code{\link{accClimateVariables}} for the list of accepted values.}

\item{df}{A data frame containing the data to reconstruct (counts,
percentages or presence/absence data).}

\item{climate_space}{A dataframe of climate values across the study area
useful to correct for the imbalance of the sampling data (see
'\code{\link{crest.calibrate}} for more details). Default is \code{NA}.}

\item{weight}{The records in the distributions can be weighted using the
percentages by setting weight=TRUE. Include a column called 'weight'
in the \code{distributions} table.}

\item{minGridCells}{The minimum number of unique presence data necessary to
estimate a species' climate response. Default is 20.}

\item{selectedTaxa}{A data frame assigns which taxa should be used for each
variable (1 if the taxon should be used, 0 otherwise). The colnames
should be the climate variables' names and the rownames the taxa
names. Default is 1 for all taxa and all variables.}

\item{site_info}{A vector containing the coordinates of the study site.
Default \code{c(NA, NA)}.}

\item{site_name}{The name of the dataset (default \code{NA}).}

\item{site_climate}{The climate values at the location of the dataset
'(default \code{NA}).}

\item{verbose}{A boolean to print non-essential comments on the terminal
(default \code{TRUE}).}
}
\value{
A \code{\link{crestObj}} object containing the spatial distributions.
}
\description{
Format a \code{crestObj} with private data.
}
\examples{
#> Reformating the example dataset to fit this function
distributions <- cbind('ProxyName'= rep('Taxon1', nrow(reconstr$modelling$distributions[[1]])),
                       reconstr$modelling$distributions[[1]],
                       stringsAsFactors = FALSE)
for(tax in names(reconstr$modelling$distributions)[-1]) {
  distributions <- rbind(distributions,
                     cbind('ProxyName'= rep(tax, nrow(reconstr$modelling$distributions[[tax]])),
                           reconstr$modelling$distributions[[tax]],
                           stringsAsFactors = FALSE)
                     )
}
distributions <- distributions[, c(2,1,3:6)]
print(head(distributions))

climate_space <- reconstr$modelling$climate_space
print(head(climate_space))

x <- crest.set_modern_data(distributions, df=crest_ex,
                           climate = c("bio1", "bio12"))
x <- crest.set_modern_data(distributions, df=crest_ex,
                           climate_space=climate_space,
                           climate = c("bio1", "bio12"))


}
