% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_sge.R
\name{crew_launcher_sge}
\alias{crew_launcher_sge}
\title{Create a launcher with Sun Grid Engine (SGE) workers.}
\usage{
crew_launcher_sge(
  name = NULL,
  seconds_launch = 60,
  seconds_interval = 0.001,
  seconds_timeout = 10,
  seconds_idle = Inf,
  seconds_wall = Inf,
  seconds_exit = 1,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE,
  sge_qsub = as.character(Sys.which("qsub")),
  sge_qdel = as.character(Sys.which("qdel")),
  sge_cwd = TRUE,
  sge_envvars = FALSE,
  sge_log_files = "/dev/null",
  sge_log_join = TRUE,
  sge_memory_gigabytes_required = NULL,
  sge_memory_gigabytes_limit = NULL,
  sge_cores = NULL,
  sge_gpu = NULL,
  sge_lines = NULL
)
}
\arguments{
\item{name}{Name of the launcher.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::server()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::server()}.}

\item{seconds_exit}{Number of seconds to wait for NNG websockets
to finish sending large data (in case an exit signal is received).
See the \code{exitlinger} argument of \code{mirai::server()}.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::server()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerlaunch} argument of \code{mirai::server()}.}

\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to unload any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.}

\item{garbage_collection}{\code{TRUE} to run garbage collection between
tasks, \code{FALSE} to skip.}

\item{sge_qsub}{Character of length 1, file path to the \code{qsub} executable
used to submit \code{crew} workers as SGE jobs.}

\item{sge_qdel}{Character of length 1, file path to the \code{qdel} executable
used to delete the SGE jobs running \code{crew} workers.}

\item{sge_cwd}{Logical of length 1, whether to
launch the worker from the current working directory (as opposed to
the user home directory). \code{sge_cwd = TRUE} translates to a line of
\verb{#$ -cwd} in the SGE job script. \code{sge_cwd = FALSE} omits this line.}

\item{sge_envvars}{Logical of length 1, whether to forward the environment
variables of the current session to the SGE worker. \code{sge_envvars = TRUE}
translates to a line of \verb{#$ -V} in the SGE job script.
\code{sge_envvars = FALSE} omits this line.}

\item{sge_log_files}{Character of length 1, file or directory path to SGE
worker log files. \code{sge_log_files = "VALUE"} translates to a line of
\verb{#$ -o VALUE} in the SGE job script. The default is \verb{/dev/null} to omit
the logs. If you do supply a value, it is recommended to supply a
directory path with a trailing slash so that each worker gets its own set
of log files.}

\item{sge_log_join}{Logical, whether to join the stdout and stderr log
files together into one file. \code{sge_log_join = TRUE} translates to a line
of \verb{#$ -j y} in the SGE job script. \code{sge_log_join = FALSE} is equivalent
to \verb{#$ -j n}.}

\item{sge_memory_gigabytes_required}{Optional positive numeric of length 1
with the gigabytes of memory required to run the worker.
\code{sge_memory_gigabytes_required = 2.4}
translates to a line of \verb{#$ -l m_mem_free=2.4G} in the SGE job script.
\code{sge_memory_gigabytes_required = NULL} omits this line.}

\item{sge_memory_gigabytes_limit}{Optional numeric of length 1
with the maximum number of gigabytes of memory a worker is allowed to
consume. If the worker consumes more than this level of memory, then
SGE will terminate it. \verb{sge_memory_gigabytes_limit = 5.7"}
translates to a line of \code{"#$ -l h_rss=5.7G"} in the SGE job script.
\code{sge_memory_gigabytes_limit = NULL} omits this line.}

\item{sge_cores}{Optional positive integer of length 1,
number of cores per worker ("slots" in SGE lingo).
\code{sge_cores = 4} translates
to a line of \verb{#$ -pe smp 4} in the SGE job script.
\code{sge_cores = NULL} omits this line.}

\item{sge_gpu}{Optional integer of length 1 with the number of GPUs to
request for the worker. \code{sge_gpu = 1} translates to a line of
\code{"#$ -l gpu=1"} in the SGE job script. \code{sge_gpu = NULL} omits this line.}

\item{sge_lines}{Optional character vector of additional lines to be
added to the SGE job script just after the more common flags.
An example would be \code{sge_lines = "module load R"} if your SGE cluster
supports R through an environment module.}
}
\description{
Create an \code{R6} object to launch and maintain
workers as Sun Grid Engine (SGE) jobs.
}
\details{
To launch a Sun Grid Engine (SGE) worker, this launcher
creates a temporary job script with a call to \code{crew::crew_worker()}
and submits it as an SGE job with \code{qsub}. To see most of the lines
of the job script in advance, use the \code{script()} method of the launcher.
It has all the lines except for the job name and the
call to \code{crew::crew_worker()}, both of
which will be inserted at the last minute when it is time
to actually launch a worker.
}
\seealso{
Other launchers: 
\code{\link{crew_class_launcher_sge}}
}
\concept{launchers}
