% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_options_sge.R
\name{crew_options_sge}
\alias{crew_options_sge}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}} SGE options.}
\usage{
crew_options_sge(
  verbose = FALSE,
  command_submit = as.character(Sys.which("qsub")),
  command_terminate = as.character(Sys.which("qdel")),
  script_directory = tempdir(),
  script_lines = character(0L),
  cwd = TRUE,
  envvars = FALSE,
  log_output = "/dev/null",
  log_error = NULL,
  log_join = TRUE,
  memory_gigabytes_limit = NULL,
  memory_gigabytes_required = NULL,
  cores = NULL,
  gpu = NULL
)
}
\arguments{
\item{verbose}{Logical, whether to see console output and error messages
when submitting worker.}

\item{command_submit}{Character of length 1,
file path to the executable to submit a worker job.}

\item{command_terminate}{Character of length 1,
file path to the executable to terminate a worker job.
Set to \code{""} to skip manually terminating the worker.
Unless there is an issue with the platform,
the job should still exit thanks to the NNG-powered network programming
capabilities of \code{mirai}. Still, if you set \code{command_terminate = ""},
you are assuming extra responsibility for manually monitoring
your jobs on the cluster and manually terminating jobs as appropriate.}

\item{script_directory}{Character of length 1, directory path to the
job scripts. Just before each job submission, a job script
is created in this folder. Script base names are unique to each
launcher and worker, and the launcher deletes the script when the
worker is manually terminated. \code{tempdir()} is the default, but it
might not work for some systems.
\code{tools::R_user_dir("crew.cluster", which = "cache")}
is another reasonable choice.}

\item{script_lines}{Optional character vector of additional lines to be
added to the job script just after the more common flags.
An example would be \code{script_lines = "module load R"} if your cluster
supports R through an environment module.}

\item{cwd}{Logical of length 1, whether to
launch the worker from the current working directory (as opposed to
the user home directory). \code{cwd = TRUE} translates to a line of
\verb{#$ -cwd} in the SGE job script. \code{cwd = FALSE} omits this line.}

\item{envvars}{Logical of length 1, whether to forward the environment
variables of the current session to the SGE worker. \code{envvars = TRUE}
translates to a line of \verb{#$ -V} in the SGE job script.
\code{envvars = FALSE} omits this line.}

\item{log_output}{Character of length 1, file or directory path to SGE
worker log files for standard output.
\code{log_output = "VALUE"} translates to a line of
\verb{#$ -o VALUE} in the SGE job script. The default is \verb{/dev/null} to omit
the logs. If you do supply a non-\verb{/dev/null} value,
it is recommended to supply a
directory path with a trailing slash so that each worker gets its own set
of log files.}

\item{log_error}{Character of length 1, file or directory path to SGE
worker log files for standard error.
\code{log_error = "VALUE"} translates to a line of
\verb{#$ -e VALUE} in the SGE job script.
The default of \code{NULL} omits this line.
If you do supply a non-\verb{/dev/null} value, it is recommended to supply a
directory path with a trailing slash so that each worker gets its own set
of log files.}

\item{log_join}{Logical, whether to join the stdout and stderr log
files together into one file. \code{log_join = TRUE} translates to a line
of \verb{#$ -j y} in the SGE job script, while \code{log_join = FALSE} is
equivalent to \verb{#$ -j n}. If \code{log_join = TRUE}, then \code{log_error}
should be \code{NULL}.}

\item{memory_gigabytes_limit}{Optional numeric vector, usually
with a single element.
Supply a vector to make \code{memory_gigabytes_limit} a retryable option
(see the "Retryable options" section for details).

\code{memory_gigabytes_limit} is
the maximum number of gigabytes of memory a worker is allowed to
consume. If the worker consumes more than this level of memory, then
SGE will terminate it. \verb{memory_gigabytes_limit = 5.7"}
translates to a line of \code{"#$ -l h_rss=5.7G"} in the SGE job script.
\code{memory_gigabytes_limit = NULL} omits this line.}

\item{memory_gigabytes_required}{Optional positive numeric vector,
usually with a single element.
Supply a vector to make \code{memory_gigabytes_required} a retryable option
(see the "Retryable options" section for details).

\code{memory_gigabytes_required} is
the gigabytes of memory required to run the worker.
\code{memory_gigabytes_required = 2.4}
translates to a line of \verb{#$ -l m_mem_free=2.4G} in the SGE job script.
\code{memory_gigabytes_required = NULL} omits this line.}

\item{cores}{Optional positive integer vector, usually with a single
element.
Supply a vector to make \code{cores} a retryable option
(see the "Retryable options" section for details).

\code{cores} is the
number of cores per worker ("slots" in SGE lingo).
\code{cores = 4} translates
to a line of \verb{#$ -pe smp 4} in the SGE job script.
\code{cores = NULL} omits this line.}

\item{gpu}{Optional integer vector, usually with a single element.
Supply a vector to make \code{gpu} a retryable option
(see the "Retryable options" section for details).

\code{gpu} is the number of GPUs to
request for the worker. \code{gpu = 1} translates to a line of
\code{"#$ -l gpu=1"} in the SGE job script. \code{gpu = NULL} omits this line.}
}
\value{
A classed list of options.
}
\description{
Set options for SGE job management.
}
\section{Retryable options}{

Arguments \code{memory_gigabytes_limit}, \code{memory_gigabytes_required},
\code{cores}, and \code{gpu} are retryable options.
Each of these arguments be a vector where each successive element is
used during a retry if the worker previously exited without
completing all its assigned tasks.
The last element of the vector is used if there are more retries than
the length of the vector.
Control the number of allowable retries with \code{crashes_error}
argument of the controller.
}

\section{Attribution}{

The template files at
\url{https://github.com/mschubert/clustermq/tree/master/inst}
informed the development of the \code{crew} launcher plugins in
\code{crew.cluster}, and we would like to thank
Michael Schubert for developing \code{clustermq} and releasing it under
the permissive Apache License 2.0.
See the \code{NOTICE} and \code{README.md} files in the \code{crew.cluster}
source code for additional attribution.
}

\examples{
  crew_options_sge()
}
\seealso{
Other sge: 
\code{\link{crew_class_launcher_sge}},
\code{\link{crew_class_monitor_sge}},
\code{\link{crew_controller_sge}()},
\code{\link{crew_launcher_sge}()},
\code{\link{crew_monitor_sge}()}
}
\concept{sge}
