% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_options_metrics.R
\name{crew_options_metrics}
\alias{crew_options_metrics}
\title{Options for logging resource usage metrics.}
\usage{
crew_options_metrics(path = NULL, seconds_interval = 5)
}
\arguments{
\item{path}{Where to write resource metric log entries for workers.
\code{path = NULL} disables logging. \code{path} equal to \code{"/dev/stdout"}
(or \code{"/dev/stderr"}) sends log messages to the standard output
(or standard error) streams, which is recommended on Unix-like systems
because then output will go to the existing log files already
configured for the
controller, e.g. through \code{\link[=crew_options_local]{crew_options_local()}} in the case of
\code{\link[=crew_controller_local]{crew_controller_local()}}. If \code{path} is not \code{NULL}, \code{"/dev/stdout"}, or
\code{"/dev/stderr"}, it should be a directory path,
in which case each worker instance will write to a new file in that
directory.

After running enough tasks in \code{crew}, you can call
\code{autometric::log_read(path)} to read all the data from all the log
files in the files or directories at \code{path},
even if the logs files are mixed with other kinds of messages.
Pass that data into \code{\link[autometric:log_read]{autometric::log_read()}} to visualize it.}

\item{seconds_interval}{Positive number, seconds between resource metric
log entries written to \code{path}.}
}
\value{
A classed list of options for logging resource usage metrics.
}
\description{
\code{\link[=crew_options_metrics]{crew_options_metrics()}} configures the
\code{crew} to record resource usage metrics (such as CPU and memory usage)
for each running worker.
To be activate resource usage logging,
the \code{autometric} R package version 0.1.0 or higher
must be installed.

Logging happens in the background (through a detached POSIX)
so as not to disrupt
the R session. On Unix-like systems, \code{\link[=crew_options_metrics]{crew_options_metrics()}}
can specify \verb{/dev/stdout} or \verb{/dev/stderr} as the log files, which will
redirect output to existing logs you are already using.
\code{\link[autometric:log_read]{autometric::log_read()}} and \code{\link[autometric:log_plot]{autometric::log_plot()}} can read and
visualize resource usage data from multiple log files, even
if those files are mixed with other messages.
}
\examples{
  crew_options_metrics()
}
\seealso{
Other options: 
\code{\link{crew_options_local}()}
}
\concept{options}
