% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher.R
\name{crew_class_launcher}
\alias{crew_class_launcher}
\title{Launcher abstract class}
\description{
\code{R6} abstract class to build other subclasses
which launch and manage workers.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
launcher <- crew_launcher_local(name = client$name)
launcher$start(workers = client$workers)
launcher$launch(index = 1L)
m <- mirai::mirai("result", .compute = client$name)
Sys.sleep(0.25)
m$data
client$terminate()
}

## ------------------------------------------------
## Method `crew_class_launcher$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
launcher <- crew_launcher_local(name = client$name)
launcher$start(workers = client$workers)
launcher$launch(index = 1L)
m <- mirai::mirai("result", .compute = client$name)
Sys.sleep(0.25)
m$data
client$terminate()
}

## ------------------------------------------------
## Method `crew_class_launcher$call`
## ------------------------------------------------

launcher <- crew_launcher_local()
launcher$call(
  socket = "ws://127.0.0.1:5000/3/cba033e58",
  launcher = "launcher_a",
  worker = 3L,
  instance = "cba033e58"
)
}
\seealso{
Other class: 
\code{\link{crew_class_client}},
\code{\link{crew_class_controller_group}},
\code{\link{crew_class_controller}},
\code{\link{crew_class_schedule}}
}
\concept{class}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{workers}}{Data frame of worker information.}

\item{\code{name}}{Name of the launcher.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{until}}{Numeric of length 1, time point when throttled unlocks.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher-new}{\code{crew_class_launcher$new()}}
\item \href{#method-crew_class_launcher-validate}{\code{crew_class_launcher$validate()}}
\item \href{#method-crew_class_launcher-settings}{\code{crew_class_launcher$settings()}}
\item \href{#method-crew_class_launcher-call}{\code{crew_class_launcher$call()}}
\item \href{#method-crew_class_launcher-start}{\code{crew_class_launcher$start()}}
\item \href{#method-crew_class_launcher-summary}{\code{crew_class_launcher$summary()}}
\item \href{#method-crew_class_launcher-done}{\code{crew_class_launcher$done()}}
\item \href{#method-crew_class_launcher-rotate}{\code{crew_class_launcher$rotate()}}
\item \href{#method-crew_class_launcher-tally}{\code{crew_class_launcher$tally()}}
\item \href{#method-crew_class_launcher-unlaunched}{\code{crew_class_launcher$unlaunched()}}
\item \href{#method-crew_class_launcher-backlogged}{\code{crew_class_launcher$backlogged()}}
\item \href{#method-crew_class_launcher-resolved}{\code{crew_class_launcher$resolved()}}
\item \href{#method-crew_class_launcher-launch}{\code{crew_class_launcher$launch()}}
\item \href{#method-crew_class_launcher-throttle}{\code{crew_class_launcher$throttle()}}
\item \href{#method-crew_class_launcher-scale}{\code{crew_class_launcher$scale()}}
\item \href{#method-crew_class_launcher-terminate}{\code{crew_class_launcher$terminate()}}
\item \href{#method-crew_class_launcher-terminate_worker}{\code{crew_class_launcher$terminate_worker()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-new}{}}}
\subsection{Method \code{new()}}{
Launcher constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$new(
  name = NULL,
  seconds_interval = NULL,
  seconds_launch = NULL,
  seconds_idle = NULL,
  seconds_wall = NULL,
  seconds_exit = NULL,
  tasks_max = NULL,
  tasks_timers = NULL,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the launcher.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
launcher <- crew_launcher_local(name = client$name)
launcher$start(workers = client$workers)
launcher$launch(index = 1L)
m <- mirai::mirai("result", .compute = client$name)
Sys.sleep(0.25)
m$data
client$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-settings"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-settings}{}}}
\subsection{Method \code{settings()}}{
List of arguments for \code{mirai::server()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$settings(socket)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{socket}}{Character of length 1, websocket address of the worker
to launch.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of arguments for \code{mirai::server()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-call"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-call}{}}}
\subsection{Method \code{call()}}{
Create a call to \code{\link[=crew_worker]{crew_worker()}} to
help create custom launchers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$call(socket, launcher, worker, instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{socket}}{Socket where the worker will receive tasks.}

\item{\code{launcher}}{Character of length 1, name of the launcher.}

\item{\code{worker}}{Positive integer of length 1, index of the worker.
This worker index remains the same even when the current instance
of the worker exits and a new instance launches.}

\item{\code{instance}}{Character of length 1 to uniquely identify
the instance of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character of length 1 with a call to \code{\link[=crew_worker]{crew_worker()}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{launcher <- crew_launcher_local()
launcher$call(
  socket = "ws://127.0.0.1:5000/3/cba033e58",
  launcher = "launcher_a",
  worker = 3L,
  instance = "cba033e58"
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-start}{}}}
\subsection{Method \code{start()}}{
Start the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$start(sockets = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sockets}}{For testing purposes only.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Creates the workers data frame.
Meant to be called once at the beginning of the launcher
life cycle, after the client has started.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} if the launcher is not started. Otherwise, a \code{tibble}
with one row per \code{crew} worker and the following columns:
\itemize{
\item \code{worker}: integer index of the worker.
\item \code{launches}: number of times the worker was launched. Each launch
occurs at a different websocket because the token at the end of the
URL is rotated before each new launch.
\item \code{assigned}: cumulative number of tasks assigned, reported by
\code{mirai::daemons()} and summed over all
completed instances of the worker. Does not reflect the activity
of the currently running instance of the worker.
\item \code{complete}: cumulative number of tasks completed, reported by
\code{mirai::daemons()} and summed over all
completed instances of the worker. Does not reflect the activity
of the currently running instance of the worker.
\item \code{socket}: current websocket URL of the worker.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-done"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-done}{}}}
\subsection{Method \code{done()}}{
Get done workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$done(daemons = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{daemons}}{\code{mirai} daemons matrix. For testing only. Users
should not set this.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A worker is "done" if it is launched and inactive.
A worker is "launched" if \code{launch()} was called
and the worker websocket has not been rotated since.
If a worker is currently online, then it is not inactive.
If a worker is not currently online, then it is inactive
if and only if (1) either it connected to the current
websocket at some point in the past,
or (2) \code{seconds_launch} seconds elapsed since launch.
}

\subsection{Returns}{
Integer index of inactive workers.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-rotate}{}}}
\subsection{Method \code{rotate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$rotate(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Integer index of a worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Rotate a websocket.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-tally"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-tally}{}}}
\subsection{Method \code{tally()}}{
Update the cumulative assigned and complete statistics.


Used to detect backlogged workers with more assigned
than complete tasks. If terminated, these workers need to be
relaunched until the backlog of assigned tasks is complete.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$tally(daemons = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{daemons}}{\code{mirai} daemons matrix. For testing only. Users
should not set this.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-unlaunched"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-unlaunched}{}}}
\subsection{Method \code{unlaunched()}}{
Get workers available for launch.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$unlaunched(n = Inf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Maximum number of worker indexes to return.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer index of workers available for launch.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-backlogged"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-backlogged}{}}}
\subsection{Method \code{backlogged()}}{
List non-launched backlogged workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$backlogged()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer vector of worker indexes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-resolved"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-resolved}{}}}
\subsection{Method \code{resolved()}}{
List non-launched non-backlogged workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$resolved()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Maximum number of worker indexes to return.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer vector of worker indexes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-launch}{}}}
\subsection{Method \code{launch()}}{
Launch a worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$launch(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Positive integer of length 1, index of the worker
to launch.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-throttle"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-throttle}{}}}
\subsection{Method \code{throttle()}}{
Throttle repeated calls.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$throttle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} to throttle, \code{FALSE} to continue.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-scale}{}}}
\subsection{Method \code{scale()}}{
Auto-scale workers out to meet the demand of tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$scale(demand, throttle = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{demand}}{Number of unresolved tasks.}

\item{\code{throttle}}{Logical of length 1, whether to delay auto-scaling
until the next auto-scaling request at least
\code{self$client$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate one or more workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$terminate(index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Integer vector of the indexes of the workers
to terminate. If \code{NULL}, all current workers are terminated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Abstract method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A handle object previously
returned by \code{launch_worker()} which allows the termination
of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Does not actually terminate a worker. This method is a
placeholder, and its presence allows manual worker termination
to be optional.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
