% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_client.R
\name{crew_class_client}
\alias{crew_class_client}
\title{\code{R6} client class.}
\description{
\code{R6} class for \code{mirai} clients.
}
\details{
See \code{\link[=crew_client]{crew_client()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
client$log()
client$terminate()
}

## ------------------------------------------------
## Method `crew_class_client$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
client$log()
client$terminate()
}
}
\seealso{
Other class: 
\code{\link{crew_class_controller_group}},
\code{\link{crew_class_controller}},
\code{\link{crew_class_launcher}},
\code{\link{crew_class_schedule}}
}
\concept{class}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{workers}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{host}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{port}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{tls_enable}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{tls_config}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{started}}{Whether the client is started.}

\item{\code{dispatcher}}{Process ID of the \code{mirai} dispatcher}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_client-new}{\code{crew_class_client$new()}}
\item \href{#method-crew_class_client-validate}{\code{crew_class_client$validate()}}
\item \href{#method-crew_class_client-start}{\code{crew_class_client$start()}}
\item \href{#method-crew_class_client-summary}{\code{crew_class_client$summary()}}
\item \href{#method-crew_class_client-terminate}{\code{crew_class_client$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-new}{}}}
\subsection{Method \code{new()}}{
\code{mirai} client constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$new(
  name = NULL,
  workers = NULL,
  host = NULL,
  port = NULL,
  tls_enable = NULL,
  tls_config = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{workers}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{host}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{port}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{tls_enable}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{tls_config}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{seconds_interval}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{seconds_timeout}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the client.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
client$log()
client$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-start}{}}}
\subsection{Method \code{start()}}{
Start listening for workers on the available sockets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$start()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-summary}{}}}
\subsection{Method \code{summary()}}{
Show an informative worker log.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{tibble} with information on the workers, or \code{NULL}
if the client is not started. The \code{tibble} has 1 row
per worker and the following columns:
\itemize{
\item \code{worker}: integer index of the worker.
\item \code{online}: \code{TRUE} if the worker is online and connected to the
websocket URL, \code{FALSE} otherwise.
\item \code{instances}: integer, number of instances of \code{mirai} servers
(\code{crew} workers) that have connected to the websocket URL
during the life cycle of the listener.
\item \code{assigned}: number of tasks assigned to the current websocket URL.
\item \code{complete}: number of tasks completed at the current websocket URL.
\item \code{socket}: websocket URL. \code{crew} changes the token at the end of the
URL path periodically as a safeguard while managing workers.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-terminate}{}}}
\subsection{Method \code{terminate()}}{
Stop the mirai client and disconnect from the
worker websockets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$terminate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
