% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_relay.R
\name{crew_class_relay}
\alias{crew_class_relay}
\title{\code{R6} relay class.}
\description{
\code{R6} class for relay configuration.
}
\details{
See \code{\link[=crew_relay]{crew_relay()}}.
}
\examples{
crew_relay()
}
\seealso{
Other relay: 
\code{\link{crew_relay}()}
}
\concept{relay}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{condition}}{Main condition variable.}

\item{\code{from}}{Condition variable to relay from.}

\item{\code{to}}{Condition variable to relay to.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_relay-validate}{\code{crew_class_relay$validate()}}
\item \href{#method-crew_class_relay-start}{\code{crew_class_relay$start()}}
\item \href{#method-crew_class_relay-terminate}{\code{crew_class_relay$terminate()}}
\item \href{#method-crew_class_relay-set_from}{\code{crew_class_relay$set_from()}}
\item \href{#method-crew_class_relay-set_to}{\code{crew_class_relay$set_to()}}
\item \href{#method-crew_class_relay-wait}{\code{crew_class_relay$wait()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_relay-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_relay-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_relay$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_relay-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_relay-start}{}}}
\subsection{Method \code{start()}}{
Start the relay object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_relay$start()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_relay-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_relay-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the relay object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_relay$terminate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_relay-set_from"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_relay-set_from}{}}}
\subsection{Method \code{set_from()}}{
Set the condition variable to relay from.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_relay$set_from(from)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{Condition variable to relay from.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_relay-set_to"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_relay-set_to}{}}}
\subsection{Method \code{set_to()}}{
Set the condition variable to relay to.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_relay$set_to(to)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{to}}{Condition variable to relay to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_relay-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_relay-wait}{}}}
\subsection{Method \code{wait()}}{
Wait until an unobserved task resolves or the timeout
is reached. Use the throttle to determine the waiting time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_relay$wait(throttle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{A \code{\link[=crew_throttle]{crew_throttle()}} object to orchestrate the
wait time intervals.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
