% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoid.R
\name{block_geoid_to}
\alias{block_geoid_to}
\alias{block_geoid_to_state}
\alias{block_geoid_to_county}
\alias{block_geoid_to_tract}
\alias{block_geoid_to_block_group}
\title{Convert Census Block GEOIDs}
\usage{
block_geoid_to(geoid, to, name = FALSE)

block_geoid_to_state(geoid, name = TRUE)

block_geoid_to_county(geoid, name = TRUE)

block_geoid_to_tract(geoid)

block_geoid_to_block_group(geoid)
}
\arguments{
\item{geoid}{A character vector of 15-digit US Census block GEOIDs.}

\item{to}{One of "state", "county", "tract", "block group" or (as an alias)
"blockgroup".}

\item{name}{Should the function return the state/county name rather than FIPS
code?}
}
\value{
A character vector of GEOIDs or names.
}
\description{
Convert the GEOID of a 2016 US Census block to the name or GEOID for the
corresponding state, county, tract or block group.
}
\details{
For details of the format of US Census GEOIDs, see
\url{https://www.census.gov/geo/reference/geoidentifiers.html}.
}
\examples{
block_geoid_to("360810443021005", to = "county", name = TRUE)

}
