% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/compareCrimes.R
\name{compareCrimes}
\alias{compareCrimes}
\title{Creates evidence variables by calculating \sQuote{distance} between crime pairs}
\usage{
compareCrimes(Pairs, crimedata, varnames, binary = TRUE, longlat = FALSE,
  show.pb = FALSE, seed = NULL)
}
\arguments{
\item{Pairs}{(n x 2) matrix of crimeIDs}

\item{crimedata}{data.frame of crime incident data. \code{crimedata} must have
  a column named: \code{crimeID}. Other column names must correspond to what
  is given in \code{varnames} list.}

\item{varnames}{list of column names corresponding to:
\itemize{
  \item spatial - X,Y coordinates (in long,lat or X,Y)
  \item temporal - DT.FROM, DT.TO
  \item categorical - (optional) any categorical variables
  \item numerical - (optional) any numeric variables
}}

\item{binary}{(logical) match/no match or all combinations for categorical
  class}

\item{longlat}{(logical) are spatial coordinates in (long,lat)?}

\item{show.pb}{(logical) show the progress bar}

\item{seed}{seed for random number generation}
}
\value{
data.frame of various proximity measures between the two crimes
}
\description{
Calculates spatial and temporal distance, difference in categorical, and
  absolute value of numerical crime variables
}
\examples{
data(crimes)

 varnames = list(
   spatial = c("X", "Y"),
   temporal = c("DT.FROM","DT.TO"),
   categorical = c("MO1",  "MO2", "MO3"))
 pairs = t(combn(as.character(crimes$crimeID[1:4]),m=2))

 compareCrimes(pairs,crimes,varnames,binary=TRUE)
}
\references{
Porter, M. D. (2014). A Statistical Approach to Crime Linkage.
   \emph{arXiv preprint arXiv:1410.2285.}.
 \url{http://arxiv.org/abs/1410.2285}
}

