% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmate.R
\name{check_format}
\alias{check_format}
\alias{assert_format}
\alias{test_format}
\alias{expect_format}
\title{Check that an argument is a valid format specification}
\usage{
check_format(x, len = NULL, min.len = NULL, max.len = NULL)

assert_format(
  x,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  .var.name = checkmate::vname(x),
  add = NULL
)

test_format(x, len = NULL, min.len = NULL, max.len = NULL)

expect_format(
  x,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}
}
\value{
\code{TRUE} if successful, otherwise a string with the error message.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
check_format("\%5.2f")
}
\seealso{
\code{\link{assertions}} for more details.
}
