% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\name{doseFunction}
\alias{doseFunction}
\alias{doseFunction,GeneralModel-method}
\alias{doseFunction-GeneralModel}
\alias{doseFunction,ModelPseudo-method}
\alias{doseFunction-ModelPseudo}
\alias{doseFunction,LogisticLogNormalOrdinal-method}
\alias{doseFunction-LogisticLogNormalOrdinal}
\title{Getting the Dose Function for a Given Model Type}
\usage{
doseFunction(model, ...)

\S4method{doseFunction}{GeneralModel}(model, ...)

\S4method{doseFunction}{ModelPseudo}(model, ...)

\S4method{doseFunction}{LogisticLogNormalOrdinal}(model, grade, ...)
}
\arguments{
\item{model}{(\code{GeneralModel} or \code{ModelPseudo})\cr the model.}

\item{...}{model specific parameters.}

\item{grade}{(\code{integer})\cr the toxicity grade for which the dose function is
required}
}
\value{
A \code{\link[=dose]{dose()}} method that computes doses.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A function that returns a \code{\link[=dose]{dose()}} method that computes the dose reaching a
specific target value of a given independent variable, based on the model
specific parameters.
}
\section{Functions}{
\itemize{
\item \code{doseFunction(GeneralModel)}: 

\item \code{doseFunction(ModelPseudo)}: 

\item \code{doseFunction(LogisticLogNormalOrdinal)}: 

}}
\examples{
my_model <- LogisticLogNormal(
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
  ref_dose = 50
)

dose_fun <- doseFunction(my_model, alpha0 = 2, alpha1 = 3)
dose_fun(0.6)
data_ordinal <- .DefaultDataOrdinal()
model <- .DefaultLogisticLogNormalOrdinal()
options <- .DefaultMcmcOptions()
suppressWarnings({
  samples <- mcmc(data_ordinal, model, options)
})

doseFunction(
  model,
  alpha1 = samples@data$alpha2,
  beta = samples@data$beta,
  grade = 1L
)(x = 0.75)
doseFunction(
  model,
  alpha2 = samples@data$alpha2,
  beta = samples@data$beta,
  grade = 2L
)(x = 0.25)
}
\seealso{
\code{\link[=dose]{dose()}}, \code{\link[=probFunction]{probFunction()}}.
}
