% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_space.R
\name{kgauss}
\alias{kgauss}
\title{Constant normalizing wrapped gaussian}
\usage{
kgauss(sigma, a)
}
\arguments{
\item{sigma}{A real number. Is the standard deviation of the wrapped
gaussian.}

\item{a}{A real number. The unit cell side length.}
}
\value{
A real number, the multiplicative constant normalizing the
wrapped gaussian atom so that the area under the curve is equal to 1.
}
\description{
Constant normalizing wrapped gaussian
}
\examples{
Z <- 16  # Sulphur atom
sigma <- 0.05*sqrt(Z)
a <- 15  # Unit cell size
kk <- kgauss(sigma,a)
print(kk)

}
