% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative.R
\name{cumulative}
\alias{cumulative}
\title{Sum of a weather variable between between two dates}
\usage{
cumulative(
  data,
  var = NULL,
  datevar = NULL,
  ndays = 5,
  na.rm = FALSE,
  startdate = NULL,
  enddate = NULL,
  monitor = FALSE,
  warn.consecutive = TRUE,
  ...
)
}
\arguments{
\item{data}{Tibble or dataframe of daily weather data}

\item{var}{Variable(s) to be extracted (Default: radn). Several columns
may be specified using column names \code{c(variable1, variable2, ...)}}

\item{datevar}{Date variable specifying day (Default: date_met)}

\item{ndays}{Number of days after/before the start or end date,
respectively. Ignored of both the start and end dates are
specified (Default: 5)}

\item{na.rm}{Used for calculations (Default: FALSE)}

\item{startdate}{Start date of data to be extracted}

\item{enddate}{Final date of data to be extracted}

\item{monitor}{For debugging. Prints data and dates. (Default:
FALSE)}

\item{warn.consecutive}{A logical indicating whether to check that
dates are consecutive, that none are missing and provide a warning if
not (Default:TRUE)}

\item{...}{options to be passed to \code{sum} calculation}
}
\value{
Numeric variable containing the sum of all values of the
weather variable \code{var} during the specified period.
}
\description{
Calculates the sum or total of daily values between two dates from
a tibble or data frame of daily weather data. Alternatively, a
number of days before or after a specific date may be
specified. Typically this is used for solar radiation, evaporation
or rainfall since the total rainfall, radiation or evaporation
during a specified period may prove useful for modelling yield or
plant growth.
}
\details{
The sum is returned but if there are any missing values, then the
sum is set to \code{NA} since the default \code{na.rm} is
\code{TRUE}. Note that if there are any missing dates, then a
warning is issued but the sum of non-missing values is returned.

If any values are missing, while the calculated sum or total may
prove useful, it will not include all the data and so may lead to
biased underestimates. Hence, in these cases it may be unlikely
that the sum is a good estimate but the appropriateness of the
estimate will depend on the exact circumstances of the missing
data and so this decision is left to the user.
}
\examples{
## Selected calculations
library(tidyverse)
cumulative(boonah, enddate = crop$flower_date[4], ndays = 3,
                    monitor = TRUE)
cumulative(boonah, enddate = crop$harvest_date[4], ndays = 3,
                    monitor = TRUE)
cumulative(boonah, startdate = crop$flower_date[4],
                    enddate = crop$harvest_date[4], monitor = TRUE)
cumulative(boonah, startdate = crop$flower_date[4],
                    enddate = crop$harvest_date[4])
cumulative(boonah, var = rain, startdate = crop$flower_date[4],
                    enddate = crop$harvest_date[4])

## Add selected totals to crop tibble
crop2 <- crop \%>\%
  mutate(totalrain_post_sow_7d =
          map_dbl(sowing_date, function(x)
            cumulative(boonah, var = rain, startdate = x, ndays = 7)),
          totalrad_flower_harvest =
            map2_dbl(flower_date, harvest_date, function(x, y)
              cumulative(boonah, var = radn, startdate = x, enddate = y)))
crop2
}
\seealso{
\code{\link{sum}}, \code{\link{daily_mean}},
\code{\link{growing_degree_days}},
\code{\link{stress_days_over}}, and
\code{\link{weather_extract}}
}
