#' Example VCF
#'
#' A VCF containing SNPs for example cqProt-003 soy data
#'
#' @format A VCF read in by read_vcf()
#' @concept data
#' @source https://doi.org/10.1007/s00122-022-04045-8
#'
"vcf"

#' Example LD matrix
#'
#' A pairwise R^2 linkage matrix generated by PLINK for example cqProt-003 soy data
#'
#' @format A square matrix read in by read_LD()
#' @concept data
#'
"LD"

#' Example phenotype data
#'
#' Seed protein scores for each individual in example cqProt-003 soy data
#'
#' @format A two-column tibble read in by read_pheno()
#' @concept data
#' @source https://doi.org/10.1007/s00122-022-04045-8
#'
"pheno"

#' Example Domestication metadata
#'
#' Metadata file with level of domestication for each individual in example cqProt-003 soy data
#'
#' @format A two-column tibble read in by read_metadata()
#' @concept data
#' @source https://doi.org/10.1007/s00122-022-04045-8
#'
"metadata"


#' Example Haplotype object
#'
#' A haplotyping object created by run_haplotyping() for example cqProt-003 soy data
#'
#' @format A haplotype (S3) object containing results needed for haplotype visualization across five epsilon values (0.2,0.4,0.6,0.8,1)
#' \describe{
#'   \item{epsilon}{Epsilon value chosen for haplotyping with DBSCAN}
#'   \item{MGmin}{MGmin value (minPts) chosen for haplotyping with DBSCAN}
#'   \item{Hapfile}{Summary of Marker Groups defining haplotype combinations}
#'   \item{Indfile}{Haplotype assignments for individuals}
#'   \item{Varfile}{Marker Group assignments for SNPs, with additional calculated information}
#'   }
#' @concept data
#'
"HapObject"
