% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.crossnma.R
\name{print.summary.crossnma}
\alias{print.summary.crossnma}
\title{Print summary of cross-design & -format network meta-analysis or
regression}
\usage{
\method{print}{summary.crossnma}(x, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{crossnma}.}

\item{digits}{The number of significant digits printed. The default
value is 3.}

\item{\dots}{Additional arguments.}
}
\value{
No return value (print function).
}
\description{
Print summary results for cross-design and cross-format network
meta-analysis or meta-regression
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
head(stddata) # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
# (suppress warning 'Adaptation incomplete' due to n.adapt = 20)
fit <-
  suppressWarnings(crossnma(mod, n.adapt = 20,
    n.iter = 50, thin = 1, n.chains = 3))

# Display the output (with 5 digits)
print(summary(fit), digits = 5)

}
\seealso{
\code{\link{summary.crossnma}}
}
\author{
Tasnim Hamza \email{tasnim.hamza@ispm.unibe.ch}
}
\keyword{print}
