% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{effect_summary}
\alias{effect_summary}
\alias{diff_mean_auto}
\alias{diff_mean_boot}
\alias{diff_median_boot}
\alias{diff_median}
\alias{diff_mean_student}
\title{Effect measure for association between one continuous and one categorical variable}
\usage{
diff_mean_auto(x, by, conf_level = 0.95, R = 500)

diff_mean_boot(x, by, conf_level = 0.95, R = 500)

diff_median_boot(x, by, conf_level = 0.95, R = 500)

diff_mean_student(x, by, conf_level = 0.95)
}
\arguments{
\item{x}{numeric vector}

\item{by}{categorical vector (of exactly 2 unique levels)}

\item{conf_level}{confidence interval level}

\item{R}{number of bootstrap replication}
}
\value{
A list with five components: effect, ci, effect.name, effect.type, and conf_level
}
\description{
User can either use or extend these functions to configure effect calculation.
}
\section{Functions}{
\itemize{
\item \code{diff_mean_auto}: (\strong{Default}) calculate a specific "difference in means" effect based on normality (Shapiro or Anderson test) and variance homogeneity (Bartlett test)

\item \code{diff_mean_boot}: calculate a "difference in means" effect with a bootstrapped CI using standard deviation

\item \code{diff_median_boot}: calculate a "difference in medians" effect with a bootstrapped CI using quantiles#'

\item \code{diff_mean_student}: calculate a "difference in means" effect using \code{t.test} confidence intervals
}}

\seealso{
\code{\link[=crosstable_effect_args]{crosstable_effect_args()}}
}
\author{
Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage

Dan Chaltiel, David Hajage
}
