% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multitest.R
\name{create_and_run_test}
\alias{create_and_run_test}
\title{Create test and run it}
\usage{
create_and_run_test(train_index, data, dependent,
  problem = c("classification", "regression"), method = c("randomForest",
  "rpart"), name, description, data_transform = identity,
  data_transform_name = "identity")
}
\arguments{
\item{train_index}{A vector containing the rows from \code{data} to be used as the training}

\item{data}{A data frame}

\item{dependent}{The dependent variable: the name of the column containing the prediction goal}

\item{problem}{Either classification or regression. This influences how the algorithms are trained and what method is used to determine performance}

\item{method}{The regression or classification method}

\item{name}{The name of the test. Printed in the test results}

\item{description}{Optional. A more elaborate description of the test}

\item{data_transform}{A quoted function name that transforms the data. It should maintain it in data frame form and maintain the dependent variable.}

\item{data_transform_name}{The name of the data transformation function}
}
\value{
An object of class 'evaluation', containing the evaluated test
}
\description{
A convenience function calling \code{\link{createtest}} first, then runs the test using \code{\link{runtest}}.
}

