% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisample.R
\name{multisample}
\alias{multisample}
\alias{multisample.cross_fold}
\alias{multisample.random}
\title{Make multiple samples of data}
\usage{
multisample.cross_fold(data, folds = 10, dependent,
  preserve_distribution = FALSE)

multisample.random(data, holdout = 0.2, iterations = 10, dependent,
  preserve_distribution = FALSE)
}
\arguments{
\item{data}{Data to sample}

\item{folds}{Number of folds to create}

\item{dependent}{The dependent variable in the data. Used only if \code{preserve_distribution=TRUE}}

\item{preserve_distribution}{Logical, only applicable if the dependent variable is a factor}

\item{holdout}{The fraction of data to be used as holdout set}

\item{iterations}{Number of iterations to make}
}
\value{
A list of numeric vectors of length 'folds'
}
\description{
Make multiple samples of data

\code{cross_fold}: Make 'folds' samples of the data, so \code{all(rbind(folds)==row.names(data))=TRUE}

\code{random}:  Makes \code{iterations} random samples of size \code{holdout * nrow(data)}
}

