% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multitest_helpers.R
\name{summary.multitest_evaluation}
\alias{summary.multitest_evaluation}
\title{Make a summary of multiple test evaluations}
\usage{
\method{summary}{multitest_evaluation}(object, ...)
}
\arguments{
\item{object}{an object for which a summary is desired.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
Object of class 'summary.multitest_evaluation'. Attributes are a list of \code{evaluation} objects,
}
\description{
Summary implementation for the results of a multitest
}
\examples{
\dontrun{
library(crtests)
library(randomForest)
library(rpart)
library(caret)
library(stringr)

# A classification multitest. The result is an object of class multitest_evaluation
multitest_evaluation <- multitest(data = iris,
                                  dependent = "Species",
                                  problem = "classification",
                                  method = "randomForest",
                                  name = "An example classification multitest",
                                  iterations = 10,
                                  cross_validation = TRUE,
                                  preserve_distribution = TRUE
)
summary(multitest_evaluation)

}
}

