% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\docType{data}
\name{HttpResponse}
\alias{HttpResponse}
\title{Base response object}
\arguments{
\item{url}{(character) A url}

\item{opts}{(list) curl options}

\item{handle}{A handle}
}
\description{
Base response object
}
\details{
\strong{Methods}
  \describe{
    \item{\code{parse()}}{
      Parse the raw response content to text
    }
    \item{\code{success()}}{
      Was status code less than or equal to 201.
      returns boolean
    }
    \item{\code{status_http()}}{
      Get HTTP status code, message, and explanation
    }
  }
}
\examples{
\dontrun{
x <- HttpResponse$new(method = "get", url = "https://httpbin.org")
x$url
x$method

x <- HttpClient$new(url = 'http://sushi.com')
(res <- x$get('/nigiri/sake.json'))
res$parse()
res$status_code
res$status_http()
res$status_http()$status_code
res$status_http()$message
res$status_http()$explanation
res$raise_for_status()
res$success()
}
}
\keyword{datasets}

