% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable-delete.R
\name{deleteSubvariables}
\alias{deleteSubvariables}
\alias{deleteSubvariable}
\title{Delete subvariables from an array}
\usage{
deleteSubvariables(variable, to.delete)

deleteSubvariable(variable, to.delete)
}
\arguments{
\item{variable}{the array variable}

\item{to.delete}{aliases (following \code{crunch.namekey.dataset}) or indices
of variables to delete.}
}
\value{
a new version of variable without the indicated subvariables
}
\description{
This function conceals the dirty work in making this happen. The array
gets unbound, the subvariables deleted, and then the remaining subvariable
are rebound into a new array.
}
\details{
Deleting requires confirmation. In an interactive session, you will be asked
to confirm. To avoid that prompt, or to delete subvariables from a
non-interactive session, wrap the call in \code{\link{with_consent}} to give
your permission to delete.
}
