% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shoji-order.R
\name{dedupeOrder}
\alias{dedupeOrder}
\title{Remove duplicated entites from an order/group}
\usage{
dedupeOrder(x)
}
\arguments{
\item{x}{VariableOrder, DatasetOrder, VariableGroup, or DatasetGroup}
}
\value{
\code{x} with duplicate entities removed.
}
\description{
This function recurses through a \code{ShojiOrder}/\code{OrderGroup} and
removes any duplicate entities. As with the default of
\code{\link[base]{duplicated}}, the first appearance of an entity is kept,
and subsequent occurences are marked as duplicated and removed. (Unlike
\code{duplicated}, however, there is no option to reverse that order.)
"First" occurence of an entity is determined by the function's recursion:
within each group, nested groups are processed first, in order, and
recursively their nested groups are processed. See the test suite, in
test-variable-order.R, for an example that illustrates which entities are
dropped as duplicate.
}
\seealso{
\code{\link{duplicates}}, which when set to \code{FALSE} also calls
this function.
}
