% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/decks.R, R/slides.R
\name{filter}
\alias{filter}
\alias{filter<-}
\alias{filter<-,CrunchDeck,ANY-method}
\alias{analyses}
\alias{analysis}
\alias{analysis<-}
\alias{query<-}
\alias{cube}
\alias{cubes}
\alias{analyses,CrunchSlide-method}
\alias{analysis,CrunchSlide-method}
\alias{analysis<-,CrunchSlide,formula-method}
\alias{analysis<-,CrunchSlide,Analysis-method}
\alias{analysis<-,CrunchSlide,list-method}
\alias{filter,CrunchSlide-method}
\alias{filter<-,CrunchSlide,ANY-method}
\alias{query<-,CrunchSlide,ANY-method}
\alias{cubes,CrunchSlide-method}
\alias{cube,CrunchSlide-method}
\alias{cubes,AnalysisCatalog-method}
\alias{query<-,Analysis,formula-method}
\alias{formulaToSlideQuery}
\alias{cube,Analysis-method}
\alias{filter,Analysis-method}
\alias{filter,ANY-method}
\alias{filter<-,Analysis,CrunchLogicalExpr-method}
\alias{filter<-,Analysis,CrunchFilter-method}
\alias{filter<-,Analysis,NULL-method}
\alias{slideQueryEnv}
\title{Get and set slide analyses}
\usage{
filter(x, ...)

filter(x) <- value

\S4method{filter}{CrunchDeck,ANY}(x) <- value

analyses(x)

analysis(x)

analysis(x) <- value

query(x) <- value

cube(x)

cubes(x)

\S4method{analyses}{CrunchSlide}(x)

\S4method{analysis}{CrunchSlide}(x)

\S4method{analysis}{CrunchSlide,formula}(x) <- value

\S4method{analysis}{CrunchSlide,Analysis}(x) <- value

\S4method{analysis}{CrunchSlide,list}(x) <- value

\S4method{filter}{CrunchSlide}(x, ...)

\S4method{filter}{CrunchSlide,ANY}(x) <- value

\S4method{query}{CrunchSlide,ANY}(x) <- value

\S4method{cubes}{CrunchSlide}(x)

\S4method{cube}{CrunchSlide}(x)

\S4method{cubes}{AnalysisCatalog}(x)

\S4method{query}{Analysis,formula}(x) <- value

formulaToSlideQuery(query, dataset)

\S4method{cube}{Analysis}(x)

\S4method{filter}{Analysis}(x, ...)

\S4method{filter}{ANY}(x, ...)

\S4method{filter}{CrunchSlide,ANY}(x) <- value

\S4method{filter}{Analysis,CrunchLogicalExpr}(x) <- value

\S4method{filter}{Analysis,CrunchFilter}(x) <- value

\S4method{filter}{Analysis,`NULL`}(x) <- value

slideQueryEnv(weight, filter)
}
\arguments{
\item{x}{a \code{CrunchSlide}, \code{AnalysisCatalog}, or \code{Analysis}}

\item{...}{ignored}

\item{value}{for the setter, a query}

\item{query}{For \code{formulaToSlideQuery()}, a formula that specifies the query, as in
\code{newSlide()}}

\item{dataset}{For \code{formulaToSlideQuery()}, a \code{CrunchDataset} that the variables in
\code{query} refer to.}

\item{weight}{For \code{slideQueryEnv()} a crunch variable to use as a weight or \code{NULL}
to indicate no weight should be used.}

\item{filter}{for \code{slideQueryEnv()}, a \code{CrunchFilter} or \code{CrunchExpression} to filter
the slide.}
}
\value{
an \code{AnalysisCatalog}, \code{Analysis}, \code{Cube}, or \code{Filter}
}
\description{
Slides are composed of analyses, which are effectively \code{CrunchCubes} with some
additional metadata. You can get and set a slide's Analysis Catalog with the
\code{analyses} method, and access an individual analysis with \code{analysis}.
}
\details{
You can get the \code{CrunchCube} from a slide or analysis with the \code{cube} method and
from a \code{CrunchDeck} with \code{cubes}. Analyses can be changed by assigning a formula
into the \code{query} function.

Advanced users of the API can assign a list to  \verb{analysis<-} to specify settings
on the analyses that are not otherwise available in \code{rcrunch}. The helpers
\code{formulaToSlideQuery()} and \code{slideQueryEnv()} help you create objects for the
\code{query} and \code{query_environment}.
}
\examples{
\dontrun{
analysis(slide)
cube(slide)
cubes(deck)
query(slide) <- ~ cyl + wt
filter(slide)
filter(slide) <- NULL # to remove a filter
filter(slide) <- filters(ds)[["My filter"]]
}
}
