% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clattice.R
\name{xtal_mat02}
\alias{xtal_mat02}
\title{Matrix for cell orthogonalisation (second choice)}
\usage{
xtal_mat02(a, b, c, aa, bb, cc)
}
\arguments{
\item{a}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{b}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{c}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{aa}{A real number. One of the unit cell's angles, in degrees.}

\item{bb}{A real number. One of the unit cell's angles, in degrees.}

\item{cc}{A real number. One of the unit cell's angles, in degrees.}
}
\value{
A \eqn{3\times }$ matrix \eqn{M} that transforms a \eqn{3\times 1} vector of fractional
        coordinates into a \eqn{3\times 1} vector of orthogonal coordinates.
}
\description{
Given the cell parameters, this function returns a matrix for
transforming fractional to orthogonal coordinates, corresponding
to the second choice in Giacovazzo's book.
}
\examples{
# Fractional coordinates
Xf = c(0.1,0.4,0.8)

# Orthorombic unit cell
M = xtal_mat02(10,40,20,90,90,90)

# Cartesian coordinates
Xc = M\%*\%Xf
}
