% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cry_generics_S3.R
\name{create_merged_reflections}
\alias{create_merged_reflections}
\title{S3 generic to create merged_reflections objects}
\usage{
create_merged_reflections(ruc, ...)
}
\arguments{
\item{ruc}{An object used to select a method.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
mrefs An object of class "merged_reflections". It is a named
        list of length 4 whose names are:
        \describe{
          \item{ruc}{An object of class "rec_unit_cell".}
          \item{csym}{An object of class "cryst_symm".}
          \item{records}{A data frame containing the data.}
          \item{dtypes}{A character vector containing the
                type of data (Miller indices, structure
                factors, etc).}
        }
}
\description{
The merged_reflections object can be created starting from
specific objects, files, etc.
}
\examples{
# Create a default merged_reflections object (no arguments)
mrefs <- create_merged_reflections()
print(mrefs)

# Create merged_reflections object from symmetry
csym <- cryst_symm("P 3")
mrefs <- create_merged_reflections(csym=csym)
print(mrefs)

}
