% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_indicators.R
\name{addLSRatio}
\alias{addLSRatio}
\title{Chart the long-short ratios}
\usage{
addLSRatio(chart, LSR)
}
\arguments{
\item{chart}{a \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} chart}

\item{LSR}{The Fear and Greed Index created by \code{\link[=getLSRatio]{getLSRatio()}}}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The long-short ratio is a market sentiment indicator on expected price movement.
}
\examples{
# Example on loading
# long-short ratio
# for the last days
# on the 15 minute candle
# wrapped in try to avoid
# failure on Github

# 1) long-short ratio
# on BTCUSDT pair
BTC_LSR <- try(
  expr = cryptoQuotes::getLSRatio(
    ticker = 'BTCUSDT',
    interval = '15m',
    from = Sys.Date() - 1,
    to   = Sys.Date()
  ),
  silent = TRUE
)

# 2) BTCSDT in same period
# as the long-short ratio;
BTCUSDT <- try(
  cryptoQuotes::getQuote(
    ticker = 'BTCUSDT',
    futures = TRUE,
    interval = '15m',
    from = Sys.Date() - 1,
    to   = Sys.Date()
  )
)

if (!inherits(x = BTC_LSR, what = 'try-error') & !inherits(x = BTCUSDT, what = "try-error")) {

  # 3) head the data
  # and display contents
  head(
    BTC_LSR
  )

  # 4) plot BTCUSDT-pair
  # with long-short ratio
  cryptoQuotes::chart(
    chart = cryptoQuotes::kline(
      BTCUSDT
    ) \%>\% cryptoQuotes::addLSRatio(
      LSR = BTC_LSR
    )
  )

}

# end of scrtipt;
}
\seealso{
Other chart indicators: 
\code{\link{addBBands}()},
\code{\link{addEvents}()},
\code{\link{addFGIndex}()},
\code{\link{addMACD}()},
\code{\link{addMA}()},
\code{\link{addRSI}()},
\code{\link{addVolume}()},
\code{\link{chart}()}
}
\concept{chart indicators}
