% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_lsr.R
\name{lsr}
\alias{lsr}
\title{Chart the long-short ratios}
\usage{
lsr(ratio, internal = list())
}
\arguments{
\item{ratio}{A \code{\link[xts:xts]{xts::xts()}}-object with the column LSRatio. See \code{\link[=get_lsratio]{get_lsratio()}} for more details.}

\item{internal}{An empty \code{\link[=list]{list()}}. This is an internal helper-argument, ignore.}
}
\value{
A \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object wrapped in \code{\link[rlang:expr]{rlang::expr()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{\link[=lsr]{lsr()}}-function adds a scatter plot as a subplot to the chart colored by ratio size.
}
\details{
The long-short ratio is a market sentiment indicator on expected price movement.
}
\examples{
\dontrun{
  # Example on loading
  # long-short ratio
  # for the last days
  # on the 15 minute candle
  # wrapped in try to avoid
  # failure on Github

  # 1) long-short ratio
  # on BTCUSDT pair
  ls_ratio <- cryptoQuotes::get_lsratio(
    ticker = 'BTCUSDT',
    interval = '15m',
    from = Sys.Date() - 1,
    to   = Sys.Date()
  )

  # 2) BTCSDT in same period
  # as the long-short ratio;
  BTC <- cryptoQuotes::get_quote(
    ticker = 'BTCUSDT',
    futures = TRUE,
    interval = '15m',
    from = Sys.Date() - 1,
    to   = Sys.Date()
  )

  # 3) plot BTCUSDT-pair
  # with long-short ratio
  cryptoQuotes::chart(
    ticker = BTC,
    main   = cryptoQuotes::kline(),
    sub    = list(
      cryptoQuotes::lsr(ratio = ls_ratio),
      cryptoQuotes::volume()
    ),
    indicator = list(
      cryptoQuotes::bollinger_bands()
    )
  )
}



# end of scrtipt;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other sentiment indicators: 
\code{\link{fgi}()}

Other subcharts: 
\code{\link{add_event}()},
\code{\link{fgi}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{volume}()}
}
\concept{chart indicators}
\concept{sentiment indicators}
\concept{subcharts}
