% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_lsr.R
\name{lsr}
\alias{lsr}
\title{Chart the long-short ratio}
\usage{
lsr(ratio, ...)
}
\arguments{
\item{ratio}{A \code{\link[xts:xts]{xts::xts()}}-object. See \code{\link[=get_lsratio]{get_lsratio()}} for more details.}

\item{...}{For internal use. Please ignore.}
}
\value{
An \link{invisible} \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-wrapper function.
The function adds a subchart to the \link{chart} with \verb{long-short ratio}.
}
\examples{
\dontrun{
  # script start;

  # 1) long-short ratio
  # on BTCUSDT pair
  LS_BTC <- cryptoQuotes::get_lsratio(
    ticker   = 'BTCUSDT',
    interval = '15m',
    from     = Sys.Date() - 1,
    to       = Sys.Date()
  )

  # 2) BTCSDT in same period
  # as the long-short ratio;
  BTC <- cryptoQuotes::get_quote(
    ticker   = 'BTCUSDT',
    futures  = TRUE,
    interval = '15m',
    from     = Sys.Date() - 1,
    to       = Sys.Date()
  )

  # 3) plot BTCUSDT-pair
  # with long-short ratio
  cryptoQuotes::chart(
    ticker = BTC,
    main   = cryptoQuotes::kline(),
    sub    = list(
      cryptoQuotes::lsr(
        ratio = LS_BTC
      )
    )
  )

  # end of scrtipt;
}

}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other sentiment indicators: 
\code{\link{fgi}()}

Other subchart indicators: 
\code{\link{add_event}()},
\code{\link{fgi}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{smi}()},
\code{\link{volume}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{sentiment indicators}
\concept{subchart indicators}
