/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.geom.AffineTransformation;
import com.vividsolutions.jump.plugin.edit.AffineTransControlPointExtracter;
import com.vividsolutions.jump.plugin.edit.TransRotScaleBuilder;
import com.vividsolutions.jump.plugin.edit.TriPointTransRotScaleBuilder;
import com.vividsolutions.jump.plugin.edit.TwoPointTransRotScaleBuilder;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class AffineTransformationPlugIn
extends ThreadedBasePlugIn {
    private MultiInputDialog dialog;
    private Layer layer;
    private double originX = 0.0;
    private double originY = 0.0;
    private double transX = 0.0;
    private double transY = 0.0;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double shearX = 0.0;
    private double shearY = 0.0;
    private double rotationAngle = 0.0;
    private static final String LAYER = "Layer";
    private static final String ORIGIN = "Anchor Point";
    private static final String ORIGIN_FROM_LL = "Set to Lower Left";
    private static final String ORIGIN_FROM_MIDPOINT = "Set to Midpoint";
    private static final String ORIGIN_X = "X";
    private static final String ORIGIN_Y = "Y";
    private static final String TRANS_DX = "DX";
    private static final String TRANS_DY = "DY";
    private static final String TRANS_DX_DY = "Translate by (X,Y)";
    private static final String SCALE_X = "X Factor";
    private static final String SCALE_Y = "Y Factor";
    private static final String ROTATE_ANGLE = "Angle";
    private static final String SHEAR_X = "X Shear";
    private static final String SHEAR_Y = "Y Shear";
    private static final String SRC_BASE_LAYER = "Source Layer";
    private static final String DEST_BASE_LAYER = "Destination Layer";
    private static final String BASELINE_BUTTON = "Compute Parameters";
    private JTextField originXField;
    private JTextField originYField;
    private JTextField transXField;
    private JTextField transYField;
    private JTextField scaleXField;
    private JTextField scaleYField;
    private JTextField shearXField;
    private JTextField shearYField;
    private JTextField rotateAngleField;

    public String getName() {
        return "Affine Transformation";
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        AffineTransformation trans = new AffineTransformation();
        AffineTransformation toOriginTrans = AffineTransformation.translationInstance(-this.originX, -this.originY);
        trans.compose(toOriginTrans);
        if (this.scaleX != 1.0 || this.scaleY != 1.0) {
            AffineTransformation scaleTrans = AffineTransformation.scaleInstance(this.scaleX, this.scaleY);
            trans.scale(this.scaleX, this.scaleY);
        }
        if (this.shearX != 0.0 || this.shearY != 0.0) {
            trans.shear(this.shearX, this.shearY);
        }
        if (this.rotationAngle != 0.0) {
            AffineTransformation rotTrans = AffineTransformation.rotationInstance(Math.toRadians(this.rotationAngle));
            trans.rotate(Math.toRadians(this.rotationAngle));
        }
        AffineTransformation fromOriginTrans = AffineTransformation.translationInstance(this.originX, this.originY);
        trans.compose(fromOriginTrans);
        if (this.transX != 0.0 || this.transY != 0.0) {
            AffineTransformation translateTrans = AffineTransformation.translationInstance(this.transX, this.transY);
            trans.compose(translateTrans);
        }
        FeatureCollectionWrapper fc = this.layer.getFeatureCollectionWrapper();
        FeatureDataset resultFC = new FeatureDataset(fc.getFeatureSchema());
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Feature f2 = f.clone(true);
            f2.getGeometry().apply((CoordinateFilter)trans);
            f2.getGeometry().geometryChanged();
            resultFC.add(f2);
        }
        this.createLayers(context, resultFC);
    }

    private void createLayers(PlugInContext context, FeatureCollection transFC) {
        Layer lyr = context.addLayer("Result", "Affine-" + this.layer.getName(), transFC);
        lyr.fireAppearanceChanged();
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("AffineTransformation.png")));
        dialog.setSideBarDescription("Applies an Affine Transformation to all features in a layer.  The transformation is specified by a combination of scaling, rotation, shearing and translation.  Transformation parameters may be computed from two layers containing baseline vectors.");
        dialog.addLayerComboBox(LAYER, context.getCandidateLayer(0), context.getLayerManager());
        dialog.addLabel("<HTML><B>Anchor Point</B></HTML>");
        this.originXField = dialog.addDoubleField(ORIGIN_X, this.originX, 20, "Anchor Point X value");
        this.originYField = dialog.addDoubleField(ORIGIN_Y, this.originY, 20, "Anchor Point Y value");
        JButton buttonOriginLL = dialog.addButton(ORIGIN_FROM_LL);
        buttonOriginLL.addActionListener(new OriginLLListener(true));
        JButton buttonOriginMid = dialog.addButton(ORIGIN_FROM_MIDPOINT);
        buttonOriginMid.addActionListener(new OriginLLListener(false));
        dialog.addLabel("<HTML><B>Scaling</B></HTML>");
        this.scaleXField = dialog.addDoubleField(SCALE_X, this.scaleX, 20, "Scale X Factor");
        this.scaleYField = dialog.addDoubleField(SCALE_Y, this.scaleY, 20, "Scale Y Factor");
        dialog.addLabel("<HTML><B>Rotation</B></HTML>");
        this.rotateAngleField = dialog.addDoubleField(ROTATE_ANGLE, this.rotationAngle, 20, "Rotation Angle in degrees");
        dialog.addLabel("<HTML><B>Shearing</B></HTML>");
        this.shearXField = dialog.addDoubleField(SHEAR_X, this.shearX, 20, "Shear X Factor");
        this.shearYField = dialog.addDoubleField(SHEAR_Y, this.shearY, 20, "Shear Y Factor");
        dialog.addLabel("<HTML><B>Translation</B></HTML>");
        this.transXField = dialog.addDoubleField(TRANS_DX, this.transX, 20, "Translation X value");
        this.transYField = dialog.addDoubleField(TRANS_DY, this.transY, 20, "Translation Y value");
        dialog.startNewColumn();
        JButton setIdentityButton = dialog.addButton("Set to Identity");
        setIdentityButton.addActionListener(new SetIdentityListener());
        dialog.addSeparator();
        dialog.addLabel("<HTML><B>Baseline Vectors</B></HTML>");
        dialog.addLayerComboBox(SRC_BASE_LAYER, context.getLayerManager().getLayer(0), context.getLayerManager());
        dialog.addLayerComboBox(DEST_BASE_LAYER, context.getLayerManager().getLayer(0), context.getLayerManager());
        JButton buttonParam = dialog.addButton(BASELINE_BUTTON);
        buttonParam.addActionListener(new UpdateParamListener());
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER);
        this.originX = dialog.getDouble(ORIGIN_X);
        this.originY = dialog.getDouble(ORIGIN_Y);
        this.transX = dialog.getDouble(TRANS_DX);
        this.transY = dialog.getDouble(TRANS_DY);
        this.scaleX = dialog.getDouble(SCALE_X);
        this.scaleY = dialog.getDouble(SCALE_Y);
        this.shearX = dialog.getDouble(SHEAR_X);
        this.shearY = dialog.getDouble(SHEAR_Y);
        this.rotationAngle = dialog.getDouble(ROTATE_ANGLE);
    }

    private void updateOriginLL(boolean isLowerLeft) {
        Layer lyr = this.dialog.getLayer(LAYER);
        FeatureCollectionWrapper fc = lyr.getFeatureCollectionWrapper();
        Envelope env = fc.getEnvelope();
        double x = env.getMinX();
        double y = env.getMinY();
        if (!isLowerLeft) {
            x = (env.getMinX() + env.getMaxX()) / 2.0;
            y = (env.getMinY() + env.getMaxY()) / 2.0;
        }
        this.originXField.setText(x + "");
        this.originYField.setText(y + "");
    }

    private String updateParams() {
        Layer layerSrc = this.dialog.getLayer(SRC_BASE_LAYER);
        Layer layerDest = this.dialog.getLayer(DEST_BASE_LAYER);
        FeatureCollectionWrapper fcSrc = layerSrc.getFeatureCollectionWrapper();
        FeatureCollectionWrapper fcDest = layerDest.getFeatureCollectionWrapper();
        AffineTransControlPointExtracter controlPtExtracter = new AffineTransControlPointExtracter(fcSrc, fcDest);
        String parseErrMsg = null;
        if (controlPtExtracter.getInputType() == 0) {
            parseErrMsg = controlPtExtracter.getParseErrorMessage();
            return parseErrMsg;
        }
        Coordinate[] srcPts = controlPtExtracter.getSrcControlPoints();
        Coordinate[] destPts = controlPtExtracter.getDestControlPoints();
        TransRotScaleBuilder trsBuilder = null;
        switch (srcPts.length) {
            case 2: {
                trsBuilder = new TwoPointTransRotScaleBuilder(srcPts, destPts);
                break;
            }
            case 3: {
                trsBuilder = new TriPointTransRotScaleBuilder(srcPts, destPts);
            }
        }
        if (trsBuilder != null) {
            this.updateParams(trsBuilder);
        }
        return null;
    }

    private void updateParams(TransRotScaleBuilder trsBuilder) {
        this.originXField.setText(trsBuilder.getOriginX() + "");
        this.originYField.setText(trsBuilder.getOriginY() + "");
        this.scaleXField.setText(trsBuilder.getScaleX() + "");
        this.scaleYField.setText(trsBuilder.getScaleY() + "");
        this.transXField.setText(trsBuilder.getTranslateX() + "");
        this.transYField.setText(trsBuilder.getTranslateY() + "");
        this.rotateAngleField.setText(trsBuilder.getRotationAngle() + "");
    }

    private void setToIdentity() {
        this.scaleXField.setText("1.0");
        this.scaleYField.setText("1.0");
        this.shearXField.setText("0.0");
        this.shearYField.setText("0.0");
        this.transXField.setText("0.0");
        this.transYField.setText("0.0");
        this.rotateAngleField.setText("0.0");
    }

    private class SetIdentityListener
    implements ActionListener {
        private SetIdentityListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AffineTransformationPlugIn.this.setToIdentity();
        }
    }

    private class UpdateParamListener
    implements ActionListener {
        private UpdateParamListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String errMsg = AffineTransformationPlugIn.this.updateParams();
            if (errMsg != null) {
                JOptionPane.showMessageDialog(null, errMsg, "Control Point Error", 0);
            }
        }
    }

    private class OriginLLListener
    implements ActionListener {
        private boolean isLowerLeft;

        OriginLLListener(boolean isLowerLeft) {
            this.isLowerLeft = isLowerLeft;
        }

        public void actionPerformed(ActionEvent e) {
            AffineTransformationPlugIn.this.updateOriginLL(this.isLowerLeft);
        }
    }
}

