/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms.ui;

import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.MapRequest;
import com.vividsolutions.wms.WMService;
import com.vividsolutions.wms.ui.ImageCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class WMSViewer
extends JFrame
implements ActionListener,
MouseListener {
    private JTextField serverUrlField;
    private JButton connectButton;
    private JButton disconnectButton;
    private JList layerList;
    private JTextField xMinField;
    private JTextField yMinField;
    private JTextField xMaxField;
    private JTextField yMaxField;
    private JComboBox srsCombo;
    private JButton getImageButton;
    private JComboBox formatCombo;
    private ImageCanvas canvas;
    private JLabel mapLabel;
    private String zoomMode;
    private WMService service;
    private boolean connected;

    public WMSViewer() {
        super("WMS Viewer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout());
        topPanel.add(new JLabel("Server String:"));
        this.serverUrlField = new JTextField("http://slkapps2.env.gov.bc.ca/servlet/com.esri.wms.Esrimap?", 30);
        topPanel.add(this.serverUrlField);
        this.connectButton = new JButton("Connect");
        this.connectButton.setActionCommand("connect");
        this.connectButton.addActionListener(this);
        topPanel.add(this.connectButton);
        this.disconnectButton = new JButton("Disconnect");
        this.disconnectButton.setActionCommand("disconnect");
        this.disconnectButton.addActionListener(this);
        this.disconnectButton.setEnabled(false);
        topPanel.add(this.disconnectButton);
        this.getContentPane().add((Component)topPanel, "North");
        this.layerList = new JList();
        this.layerList.setSelectionMode(2);
        this.getContentPane().add((Component)new JScrollPane(this.layerList), "West");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        JPanel thePanel = new JPanel();
        thePanel.setLayout(new GridLayout(5, 2));
        thePanel.add(new JLabel("X-Min:"));
        this.xMinField = new JTextField("1375470", 7);
        thePanel.add(this.xMinField);
        thePanel.add(new JLabel("Y-Min:"));
        this.yMinField = new JTextField("701069", 7);
        thePanel.add(this.yMinField);
        thePanel.add(new JLabel("X-Max:"));
        this.xMaxField = new JTextField("1401720", 7);
        thePanel.add(this.xMaxField);
        thePanel.add(new JLabel("Y-Max:"));
        this.yMaxField = new JTextField("714194", 7);
        thePanel.add(this.yMaxField);
        thePanel.add(new JLabel("SRS:"));
        this.srsCombo = new JComboBox();
        thePanel.add(this.srsCombo);
        rightPanel.add((Component)thePanel, "North");
        thePanel = new JPanel();
        thePanel.setLayout(new GridLayout(3, 1));
        ButtonGroup bg = new ButtonGroup();
        JRadioButton rb = new JRadioButton("Pan");
        rb.setActionCommand("pan");
        rb.addActionListener(this);
        rb.setSelected(true);
        this.zoomMode = "pan";
        thePanel.add(rb);
        bg.add(rb);
        rb = new JRadioButton("Zoom In");
        rb.setActionCommand("zoomIn");
        rb.addActionListener(this);
        thePanel.add(rb);
        bg.add(rb);
        rb = new JRadioButton("Zoom Out");
        rb.setActionCommand("zoomOut");
        rb.addActionListener(this);
        thePanel.add(rb);
        bg.add(rb);
        rightPanel.add((Component)thePanel, "South");
        this.getContentPane().add((Component)rightPanel, "East");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        this.formatCombo = new JComboBox();
        bottomPanel.add(this.formatCombo);
        this.getImageButton = new JButton("Get Image");
        this.getImageButton.setActionCommand("getImage");
        this.getImageButton.addActionListener(this);
        this.getImageButton.setEnabled(false);
        bottomPanel.add(this.getImageButton);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.canvas = new ImageCanvas();
        this.canvas.addMouseListener(this);
        this.getContentPane().add((Component)this.canvas, "Center");
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command.equals("connect")) {
            try {
                this.service = new WMService(this.serverUrlField.getText());
                this.service.initialize();
                Iterator it = this.service.getCapabilities().getTopLayer().getLayerList().iterator();
                DefaultListModel<String> lm = new DefaultListModel<String>();
                while (it.hasNext()) {
                    lm.addElement(((MapLayer)it.next()).getName());
                }
                this.layerList.setModel(lm);
                it = this.service.getCapabilities().getTopLayer().getSRSList().iterator();
                DefaultComboBoxModel cm = new DefaultComboBoxModel();
                while (it.hasNext()) {
                    cm.addElement(it.next());
                }
                this.srsCombo.setModel(cm);
                String[] formats = this.service.getCapabilities().getMapFormats();
                cm = new DefaultComboBoxModel();
                for (int i = 0; i < formats.length; ++i) {
                    cm.addElement(formats[i]);
                }
                this.formatCombo.setModel(cm);
                this.connectButton.setEnabled(false);
                this.disconnectButton.setEnabled(true);
                this.getImageButton.setEnabled(true);
                this.connected = true;
            }
            catch (IOException ioe) {}
        } else if (command.equals("disconnect")) {
            this.layerList.setModel(new DefaultListModel());
            this.srsCombo.setModel(new DefaultComboBoxModel());
            this.formatCombo.setModel(new DefaultComboBoxModel());
            this.getImageButton.setEnabled(false);
            this.disconnectButton.setEnabled(false);
            this.connectButton.setEnabled(true);
            this.canvas.setImage(null);
        } else if (command.equals("getImage")) {
            Image mapImage;
            MapRequest req = this.service.createMapRequest();
            req.setImageSize(this.canvas.getWidth(), this.canvas.getHeight());
            req.setFormat((String)this.formatCombo.getSelectedItem());
            req.setLayers(Arrays.asList(this.layerList.getSelectedValues()));
            req.setBoundingBox(new BoundingBox((String)this.srsCombo.getSelectedItem(), Float.parseFloat(this.xMinField.getText()), Float.parseFloat(this.yMinField.getText()), Float.parseFloat(this.xMaxField.getText()), Float.parseFloat(this.yMaxField.getText())));
            try {
                System.out.println("Url: " + req.getURL());
                mapImage = req.getImage();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return;
            }
            this.canvas.setImage(mapImage);
            this.canvas.repaint();
        } else if (command.equals("pan")) {
            this.zoomMode = "pan";
        } else if (command.equals("zoomIn")) {
            this.zoomMode = "zoomIn";
        } else if (command.equals("zoomOut")) {
            this.zoomMode = "zoomOut";
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.canvas) {
            System.out.println("click");
            int x = mouseEvent.getX();
            int y = mouseEvent.getY();
            float xMin = Float.parseFloat(this.xMinField.getText());
            float yMin = Float.parseFloat(this.yMinField.getText());
            float xMax = Float.parseFloat(this.xMaxField.getText());
            float yMax = Float.parseFloat(this.yMaxField.getText());
            float mapWidth = xMax - xMin;
            float mapHeight = yMax - yMin;
            int imgWidth = this.canvas.getWidth();
            int imgHeight = this.canvas.getHeight();
            float xCenter = xMin + (float)x / (float)imgWidth * mapWidth;
            float yCenter = yMax - (float)y / (float)imgHeight * mapHeight;
            if (this.zoomMode.equals("zoomIn")) {
                mapWidth /= 2.0f;
                mapHeight /= 2.0f;
            } else if (this.zoomMode.equals("zoomOut")) {
                mapWidth *= 2.0f;
                mapHeight *= 2.0f;
            }
            xMin = xCenter - mapWidth / 2.0f;
            yMin = yCenter - mapHeight / 2.0f;
            xMax = xCenter + mapWidth / 2.0f;
            yMax = yCenter + mapHeight / 2.0f;
            this.xMinField.setText("" + xMin);
            this.yMinField.setText("" + yMin);
            this.xMaxField.setText("" + xMax);
            this.yMaxField.setText("" + yMax);
            this.getImageButton.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public static void main(String[] args) {
        WMSViewer viewer = new WMSViewer();
    }
}

