/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jump.qa.diff.DiffGeometryMatcher;
import com.vividsolutions.jump.qa.diff.MatchCollection;
import com.vividsolutions.jump.qa.diff.MatchGeometry;
import java.util.Iterator;
import java.util.List;

public class MatchIndex {
    private SpatialIndex index;

    public MatchIndex(MatchCollection matchColl) {
        this.buildIndex(matchColl);
    }

    private void buildIndex(MatchCollection matchColl) {
        this.index = new STRtree();
        Iterator i = matchColl.geometryIterator();
        while (i.hasNext()) {
            MatchGeometry matchGeom = (MatchGeometry)i.next();
            this.index.insert(matchGeom.getGeometry().getEnvelopeInternal(), (Object)matchGeom);
        }
    }

    public void testMatch(MatchCollection matchColl, DiffGeometryMatcher diffMatcher) {
        Iterator i = matchColl.geometryIterator();
        while (i.hasNext()) {
            MatchGeometry matchGeom = (MatchGeometry)i.next();
            this.testMatch(matchGeom, diffMatcher);
        }
    }

    public boolean testMatch(MatchGeometry testGeom, DiffGeometryMatcher diffMatcher) {
        diffMatcher.setQueryGeometry(testGeom.getGeometry());
        List resultList = this.index.query(diffMatcher.getQueryGeometry().getEnvelopeInternal());
        Iterator j = resultList.iterator();
        while (j.hasNext()) {
            MatchGeometry matchGeom = (MatchGeometry)j.next();
            if (matchGeom.isMatched() || !diffMatcher.isMatch(matchGeom.getGeometry())) continue;
            matchGeom.setMatch(testGeom);
            testGeom.setMatch(matchGeom);
            return true;
        }
        return false;
    }
}

