/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import java.io.Serializable;

public abstract class AbstractBasicFeature
implements Feature,
Serializable {
    private static final long serialVersionUID = 4215477286292970800L;
    private FeatureSchema schema;
    private int id = FeatureUtil.nextID();

    public void setSchema(FeatureSchema schema) {
        this.schema = schema;
    }

    public AbstractBasicFeature(FeatureSchema featureSchema) {
        this.schema = featureSchema;
    }

    public int getID() {
        return this.id;
    }

    public void setAttribute(String attributeName, Object newAttribute) {
        this.setAttribute(this.schema.getAttributeIndex(attributeName), newAttribute);
    }

    public void setGeometry(Geometry geometry) {
        this.setAttribute(this.schema.getGeometryIndex(), (Object)geometry);
    }

    public Object getAttribute(String name) {
        return this.getAttribute(this.schema.getAttributeIndex(name));
    }

    public String getString(int attributeIndex) {
        Object result = this.getAttribute(attributeIndex);
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    public int getInteger(int attributeIndex) {
        return (Integer)this.getAttribute(attributeIndex);
    }

    public double getDouble(int attributeIndex) {
        return (Double)this.getAttribute(attributeIndex);
    }

    public String getString(String attributeName) {
        return this.getString(this.schema.getAttributeIndex(attributeName));
    }

    public Geometry getGeometry() {
        return (Geometry)this.getAttribute(this.schema.getGeometryIndex());
    }

    public FeatureSchema getSchema() {
        return this.schema;
    }

    public Object clone() {
        return this.clone(true);
    }

    public Feature clone(boolean deep) {
        return AbstractBasicFeature.clone(this, deep);
    }

    public static BasicFeature clone(Feature feature, boolean deep) {
        BasicFeature clone = new BasicFeature(feature.getSchema());
        for (int i = 0; i < feature.getSchema().getAttributeCount(); ++i) {
            if (feature.getSchema().getAttributeType(i) == AttributeType.GEOMETRY) {
                clone.setAttribute(i, deep ? feature.getGeometry().clone() : feature.getGeometry());
                continue;
            }
            clone.setAttribute(i, feature.getAttribute(i));
        }
        return clone;
    }

    public int compareTo(Object o) {
        return AbstractBasicFeature.compare(this, (Feature)o);
    }

    public static int compare(Feature a, Feature b) {
        int geometryComparison = a.getGeometry().compareTo((Object)b.getGeometry());
        if (geometryComparison != 0) {
            return geometryComparison;
        }
        if (a == b) {
            return 0;
        }
        if (a.getID() != b.getID()) {
            return a.getID() - b.getID();
        }
        if (a.hashCode() != b.hashCode()) {
            return a.hashCode() - b.hashCode();
        }
        Assert.shouldNeverReachHere();
        return -1;
    }
}

