% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_toc.R
\name{cso_get_toc}
\alias{cso_get_toc}
\title{Returns a data frame with all valid CSO Statbank tables listed sequentially
by id number, e.g. A0101, A0102, A0103, etc.}
\usage{
cso_get_toc(cache = TRUE, suppress_messages = FALSE)
}
\arguments{
\item{cache}{logical. If TRUE (default) the table of contents is cached
with the system date as a key.}

\item{suppress_messages}{logical. If FALSE (default) a message is printed
when loading a previously cached table of contents.}
}
\value{
data frame of three character columns:
\itemize{
  \item id. Contains all of the table codes currently
available on the CSO API.
  \item LastModified. The date the table was last modified in POSIXct
  format.
  \item title. The title of the table.
}
}
\description{
Checks the CSO Statbank API for a list of all the table codes (e.g. A0101,
A0102, A0103, etc.), which also includes date last modified and title for
each table, and returns this list as an R data frame.
}
\details{
The data is pulled from the TitledetailsList on the CSO API. See
\url{https://statbank.cso.ie/StatbankServices/StatbankServices.svc/
jsonservice/help/operations/TitledetailsList}
for more information on this.
}
\examples{
head(cso_get_toc())
}
