% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csvwr.R
\name{create_metadata}
\alias{create_metadata}
\title{Create tabular metadata from a list of tables}
\usage{
create_metadata(tables)
}
\arguments{
\item{tables}{a list of \code{csvw:table} annotations}
}
\value{
a list describing a tabular metadata annotation
}
\description{
The table annotations should each be a list with keys for \code{url} and \code{tableSchema}.
You can use \code{derive_table_schema} to derive a schema from a data frame.
}
\examples{
d <- data.frame(foo="bar")
table <- list(url="filename.csv", tableSchema=derive_table_schema(d))
create_metadata(tables=list(table))
}
