% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctbi.long.term.R
\name{ctbi.long.term}
\alias{ctbi.long.term}
\title{ctbi.long.term}
\usage{
ctbi.long.term(data0, n.bin.min, seq.bin.side, outliers.checked)
}
\arguments{
\item{data0}{data.table with the columns x (time series), y (values), side.index (index associated with each bin defined between two consecutive centers) and index.bin (index associated with each bin defined between two consecutive sides)}

\item{n.bin.min}{minimum number of points for a bin to be accepted}

\item{seq.bin.side}{sequence of the sides of the bins}

\item{outliers.checked}{boolean to indicate if the median (outliers.checked = FALSE) or the mean (outliers.checked = TRUE) should be used to calculate the long-term trend}
}
\value{
data0 with the long-term trend added (column long.term)
}
\description{
Calculate the long-term trend with a linear interpolation between the mean (or median) of bins defined between two consecutive centers. Bins defined between two consecutive sides are calculated as well to complete for missing values if they have neighbors. Bins without sufficient data are discarded.
}
\examples{
library(data.table)
x <- seq(from=as.Date('2001-01-01'),to=as.Date('2010-12-01'),by='1 month')
y <- 3*cos(2*pi*(0:(length(x)-1))/12)+runif(length(x))
outliers.checked <- TRUE
seq.bin.side <- seq(from=as.Date('2001-01-01'),to=as.Date('2011-01-01'),by='1 year')
seq.bin.center <- seq(from=as.Date('2001-06-01'),to=as.Date('2010-06-01'),by='1 year')
index.bin <- findInterval(x,seq.bin.side)
side.index <- findInterval(x,seq.bin.center)+0.5
n.bin.min <- 10 # minimum of 10 months of data for a bin to be accepted
data0 <- data.table(x=x,y=y,index.bin=index.bin,side.index=side.index)
data0.with.long.term <- ctbi.long.term(data0,n.bin.min,seq.bin.side,outliers.checked)
}
