\name{ctmm-package}
\alias{ctmm-package}
\encoding{UTF-8}
\docType{package}
\title{Continuous-time movement modeling}
\description{
Description: Functions for identifying, fitting, and applying continuous-space, continuous-time stochastic movement models to animal tracking data.
The package is described in Calabrese & Fleming (2016) and its methods are based on those introduced in Fleming et al (2014-2016) and Péron et al (2016).
}
\details{
\tabular{ll}{
Package: \tab ctmm\cr
Type: \tab Package\cr
Version: \tab 0.3.6 \cr
Date: \tab 2017-04-23 \cr
License: \tab GPL-3 \cr
}

\itemize{
\item{ \link{ctmm-FAQ} }
\item{ \href{http://biology.umd.edu/movement.html}{CTMM Initiative} }
\item{ \href{http://www2.physics.umd.edu/~hfleming/}{Beta packages} }
\item{ \href{https://github.com/ctmm-initiative/ctmm}{Github project} }
\item{ \href{https://ctmm-initiative.github.io/ctmm/}{Github reference} }
\item{ \href{https://CRAN.R-project.org/package=ctmm}{CRAN package} }
\item{ \href{https://groups.google.com/forum/#!forum/ctmm-user}{Google group} }
}

}

\author{
Christen H. Fleming and Justin M. Calabrese

Maintainer: Christen H. Fleming <flemingc@si.edu>
}
\references{
J. M. Calabrese, C. H. Fleming. (2016). ctmm: an R package for analyzing animal relocation data as a continuous-time stochastic process. \href{http://onlinelibrary.wiley.com/wol1/doi/10.1111/2041-210X.12559/abstract}{Methods in Ecology and Evolution, DOI:10.1111/2041-210X.12559}.

C. H. Fleming, J. M. Calabrese, T. Mueller, K.A. Olson, P. Leimgruber, and W. F. Fagan. (2014).
From fine-scale foraging to home ranges: A semi-variance approach to identifying movement modes across spatiotemporal scales.
\href{http://www.jstor.org/discover/10.1086/675504}{The American Naturalist, 183(5), E154-E167}.

C. H. Fleming and J. M. Calabrese and T. Mueller and K. A. Olson and P. Leimgruber, and W. F. Fagan (2014).
Non-Markovian maximum likelihood estimation of autocorrelated movement processes
\href{http://onlinelibrary.wiley.com/doi/10.1111/2041-210X.12176/abstract}{Methods in Ecology and Evolution, 5(5) 462-472}.

C. H. Fleming and Y. Subasi and J. M. Calabrese. (2015).
A maximum-entropy description of animal movement.
\href{http://journals.aps.org/pre/abstract/10.1103/PhysRevE.91.032107}{Physical Review E, 91, 032107}.

C. H. Fleming and W. F. Fagan and T. Mueller and K. A. Olson and P. Leimgruber, and J. M. Calabrese (2015).
Rigorous home-range estimation with movement data: A new autocorrelated kernel-density estimator.
\href{http://www.esajournals.org/doi/abs/10.1890/14-2010.1}{Ecology, 96(5), 1182-1188}.

C. H. Fleming, W. F. Fagan, T. Mueller, K. A. Olson, P. Leimgruber, and J. M. Calabrese. (2016).
Estimating where and how animals travel: An optimal framework for path reconstruction from autocorrelated tracking data.
\href{http://onlinelibrary.wiley.com/doi/10.1890/15-1607/full}{Ecology, DOI:10.1890/15-1607}.

G. Péron, C. H. Fleming,  R. C. de Paula, J. M. Calabrese. (2016). Uncovering periodic patterns of space use in animal tracking data with periodograms, including a new algorithm for the Lomb-Scargle periodogram and improved randomization tests. \href{https://movementecologyjournal.biomedcentral.com/articles/10.1186/s40462-016-0084-7}{Movement Ecology, 4:19, DOI:10.1186/s40462-016-0084-7}.

C. H. Fleming, J. M. Calabrese, A new kernel-density estimator for accurate home-range and species-range area estimation, \href{http://onlinelibrary.wiley.com/wol1/doi/10.1111/2041-210X.12673/abstract}{Methods in Ecology and Evolution, DOI:10.1111/2041-210X.12673 (2016)}.
}

%~~ Optionally other standard keywords, one per line, from file KEYWORDS in ~~
%~~ the R documentation directory ~~
%\keyword{ package }

%\note{}

%\seealso{}
%\examples{
%~~ simple examples of the most important functions ~~
%}
