% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_numSites.R
\name{f.numSites}
\alias{f.numSites}
\title{Calculate number of sites of a study}
\usage{
f.numSites(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.numSites`, an integer.
}
\description{
Trial concept calculated: number of the sites where the trial is conducted.
EUCTR lacks information on number of sites outside of the EEA;
for each non-EEA country mentioned, at least one site is assumed.
}
\examples{
# fields needed
f.numSites()

\dontrun{

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.numSites",
  con = dbc)
}

}
