% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanGenerate.R
\name{ctStanGenerate}
\alias{ctStanGenerate}
\title{Generate data from a ctstanmodel object}
\usage{
ctStanGenerate(
  ctm,
  datastruct,
  optimize = TRUE,
  is = FALSE,
  fullposterior = TRUE,
  nsamples = 200,
  parsonly = FALSE,
  includePreds = FALSE,
  ...
)
}
\arguments{
\item{ctm}{\code{\link{ctStanModel}} object.}

\item{datastruct}{long format data structure as used by ctsem.}

\item{optimize}{Whether to optimize or use Stan's HMC sampler}

\item{is}{If optimizing, follow up with importance sampling?}

\item{fullposterior}{Generate from the full posterior or just the mean?}

\item{nsamples}{How many samples to generate?}

\item{parsonly}{If TRUE, only return samples of raw parameters, don't generate data.}

\item{includePreds}{if TRUE, the prior for covariate effects (TD and TI predictors)
is included, as well as the TD and TI pred data. Else the effects are set to zero.}

\item{...}{arguments to pass to stanoptimis}
}
\value{
Array of nsamples x time points x manifest variables.
}
\description{
Generate data from a ctstanmodel object
}
\examples{
\donttest{
#generate and plot samples from prior predictive
priorpred <- ctStanGenerate(ctm = ctstantestfit$ctstanmodelbase,
  datastruct = ctstantestdat,cores=2,nsamples = 50)
}
}
