% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_public_chemical_list_by_name}
\alias{get_public_chemical_list_by_name}
\title{Get chemical list by name}
\usage{
get_public_chemical_list_by_name(
  list_name = NULL,
  Projection = "",
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{list_name}{The name of the list of chemicals}

\item{Projection}{Optional parameter controlling return type. It takes values
chemicallistall' and 'chemicallistname' with the former as the default
value.}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing information about the chemical list. Note,
this is not the chemical list itself. To access the chemicals in the list,
use \code{\link{get_chemicals_in_list}}.
}
\description{
Get chemical list by name
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical list by list name
ccl4 <- get_public_chemical_list_by_name(list_name = 'CCL4')
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{get_chemicals_in_list}}
}
