% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_dp}
\alias{get_dp}
\title{Deviaiton from Proportionality}
\usage{
get_dp(cf, host_weights, codon_table = get_codon_table())
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{host_weights}{a named vector of tRNA weights for each codon that reflects the relative
availability of tRNAs in the host organism.}

\item{codon_table}{a table of genetic code derived from `get_codon_table` or `create_codon_table`.}
}
\value{
a named vector of dp values.
}
\description{
\code{get_dp} calculates Deviation from Proportionality of each CDS.
}
\examples{
# estimate DP of yeast genes
cf_all <- count_codons(yeast_cds)
trna_weight <- est_trna_weight(yeast_trna_gcn)
trna_weight <- setNames(trna_weight$w, trna_weight$codon)
dp <- get_dp(cf_all, host_weights = trna_weight)
head(dp)
hist(dp)

}
\references{
Chen F, Wu P, Deng S, Zhang H, Hou Y, Hu Z, Zhang J, Chen X, Yang JR. 2020.
  Dissimilation of synonymous codon usage bias in virus-host coevolution due to translational
  selection. Nat Ecol Evol 4:589-600.
}
