% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predcall_tneh.R
\name{predcall_tneh}
\alias{predcall_tneh}
\title{predcall_tneh function}
\usage{
predcall_tneh(
  object,
  pred,
  z_tau = z_tau,
  z_alpha = z_alpha,
  x = x,
  xmax = NULL,
  level = level,
  epsilon = epsilon,
  cumLexc_topred
)
}
\arguments{
\item{object}{ouput from a model implemented in curesurv}

\item{pred}{some predicted estimates}

\item{z_tau}{Covariates matrix acting on time-to-null parameter.}

\item{z_alpha}{Covariates matrix acting on parameter alpha of the density of
time-to-null excess hazard model}

\item{x}{time at which the predictions are provided}

\item{xmax}{time max at which Pi(t) is calculated.}

\item{level}{(1-alpha/2)-order quantile of a normal distribution}

\item{epsilon}{value fixed by user to estimate the \eqn{\text{Pi}(t)\geq (1-\epsilon)}.
By default \eqn{\epsilon = 0.05}.}

\item{cumLexc_topred}{pre prediction obtained either from cumLexc_adtneh2_topred or cumLexc_mul_topred}
}
\description{
calculates the predicted cure indicators from a Time to null
excess hazard model.
}
\references{
Boussari O, Bordes L, Romain G, Colonna M, Bossard N, Remontet L,
Jooste V. Modeling excess hazard with time-to-cure as a parameter.
Biometrics. 2021 Dec;77(4):1289-1302. doi: 10.1111/biom.13361.
Epub 2020 Sep 12. PMID: 32869288.
(\href{https://pubmed.ncbi.nlm.nih.gov/32869288/}{pubmed})

Boussari O, Romain G, Remontet L, Bossard N, Mounier M, Bouvier AM,
Binquet C, Colonna M, Jooste V. A new approach to estimate time-to-cure from
cancer registries data. Cancer Epidemiol. 2018 Apr;53:72-80.
doi: 10.1016/j.canep.2018.01.013. Epub 2018 Feb 4. PMID: 29414635.
(\href{https://pubmed.ncbi.nlm.nih.gov/29414635/}{pubmed})
}
\author{
Juste Goungounga, Judith Breaud, Eugenie Blandin, Olayide Boussari, Valerie Jooste
}
\keyword{internal}
